---
id: 5d822fd413a79914d39e98cc
title: Step 4
challengeType: 0
dashedName: step-4
---

# --description--

Within the `head`, nest a `meta` element with a `charset` of `UTF-8`, a `title` element with a title of `City Skyline`, and a `link` element that links your `styles.css` file.

# --hints--

You should create a `meta` element within the `head` element.

```js
const headContentRegex = /(?<=<head\s*>)[\S|\s]*(?=<\/head\s*>)/;
const headElementContent = code.match(headContentRegex);

const headElement = document.createElement("head");
headElement.innerHTML = headElementContent;
assert.isNotNull(headElement.querySelector('meta'));
```

You should give the `meta` tag a `charset` of `UTF-8`.

```js
const linkElement = document.querySelector('meta');
const charset = linkElement?.getAttribute("charset").toLowerCase();
assert.strictEqual(charset, 'utf-8');
```

Your code should have a `title` element.

```js
const title = document.querySelector('title');
assert.exists(title);
```

The `title` element should be within the `head` element.

```js
const headContentRegex = /(?<=<head\s*>)[\S|\s]*(?=<\/head\s*>)/;
const headElementContent = code.match(headContentRegex);

const headElement = document.createElement("head");
headElement.innerHTML = headElementContent;
assert.isNotNull(headElement.querySelector('title'));
```

Your project should have a title of `City Skyline`.

```js
const title = document.querySelector('title');
assert.equal(title.text.toLowerCase(), 'city skyline')
```

Remember, the casing and spelling matters for the title.

```js
const title = document.querySelector('title');
assert.equal(title.text, 'City Skyline');
```

Your code should have a `link` element.

```js
assert.isNotNull(document.querySelector('link'));
```

You should not change your existing `head` tags. Make sure you did not delete the closing tag.

```js
const headElements = document.querySelectorAll('head');
assert.strictEqual(headElements?.length, 1);
```

You should have one void `link` element.

```js
assert.strictEqual(document.querySelectorAll('link')?.length, 1);
```

Your `link` element should be within your `head` element.

```js
const headContentRegex = /(?<=<head\s*>)[\S|\s]*(?=<\/head\s*>)/;
const headElementContent = code.match(headContentRegex);

const headElement = document.createElement("head");
headElement.innerHTML = headElementContent;
assert.isNotNull(headElement.querySelector('link'));
```

Your `link` element should have a `rel` attribute with the value `stylesheet`.

```js
const linkElement = document.querySelector('link');
const rel = linkElement?.getAttribute("rel");
assert.strictEqual(rel, "stylesheet");
```

Your `link` element should have an `href` attribute with the value `styles.css`.

```js
const linkElement = document.querySelector('link');
assert.strictEqual(linkElement?.dataset.href, "styles.css");
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
--fcc-editable-region--
  <head>
    
  </head>
--fcc-editable-region--
  <body>
  </body>
</html>
```
