---
id: 66475bab40e5125c84b03337
title: Step 16
challengeType: 20
dashedName: step-16
---

# --description--

Now that you have the rounded coordinates, find the maximum value between all the x coordinates and the maximum value between all the y coordinates.

These max values will be the number of rows and columns in the graph. Save the first in a new variable named `x_max` and the second in a variable named `y_max`.

Return `x_max, y_max`.

# --hints--

The method should return `x_max, y_max`.

```js
({
    test: () => runPython(`
    assert _Node(_code).find_class('Graph').find_function('create_trajectory').has_return('x_max, y_max'), "return x_max, y_max missing"
    `)
})
```

The variable `x_max` should contain the highest x value.

```js
({
    test: () => {
        runPython(`
            ball = Projectile(10, 3, 45)
            coordinates = ball.calculate_all_coordinates()
            graph = Graph(coordinates)
            assert graph.create_trajectory()[0] == round(max(coordinates, key=lambda i: round(i[0]))[0])

        `)
    }
})
```

The variable `y_max` should contain the highest y value.

```js
({
    test: () => {
        runPython(`
            ball = Projectile(10, 3, 45)
            coordinates = ball.calculate_all_coordinates()
            graph = Graph(coordinates)
            assert graph.create_trajectory()[1] == round(max(coordinates, key=lambda i: round(i[1]))[1])

        `)
    }
})
```

# --seed--

## --seed-contents--

```py
import math

GRAVITATIONAL_ACCELERATION = 9.81
PROJECTILE = "∙"
x_axis_tick = "T"
y_axis_tick = "⊣"

class Projectile:
    __slots__ = ('__speed', '__height', '__angle')

    def __init__(self, speed, height, angle):
        self.__speed = speed
        self.__height = height
        self.__angle = math.radians(angle)
        
    def __str__(self):
        return f'''
Projectile details:
speed: {self.speed} m/s
height: {self.height} m
angle: {self.angle}°
displacement: {round(self.__calculate_displacement(), 1)} m
'''

    def __calculate_displacement(self):
        horizontal_component = self.__speed * math.cos(self.__angle)
        vertical_component = self.__speed * math.sin(self.__angle)
        squared_component = vertical_component**2
        gh_component = 2 * GRAVITATIONAL_ACCELERATION * self.__height
        sqrt_component = math.sqrt(squared_component + gh_component)
        
        displacement = horizontal_component * (vertical_component + sqrt_component) / GRAVITATIONAL_ACCELERATION
        return displacement
        
    def __calculate_y_coordinate(self, x):
        height_component = self.__height
        angle_component = math.tan(self.__angle) * x
        acceleration_component = GRAVITATIONAL_ACCELERATION * x ** 2 / (
                2 * self.__speed ** 2 * math.cos(self.__angle) ** 2)
        y_coordinate = height_component + angle_component - acceleration_component

        return y_coordinate
    
    def calculate_all_coordinates(self):
        return [
            (x, self.__calculate_y_coordinate(x))
            for x in range(math.ceil(self.__calculate_displacement()))
        ]

    @property
    def height(self):
        return self.__height

    @property
    def angle(self):
        return round(math.degrees(self.__angle))

    @property
    def speed(self):
        return self.__speed

    @height.setter
    def height(self, n):
        self.__height = n

    @angle.setter
    def angle(self, n):
        self.__angle = math.radians(n)

    @speed.setter
    def speed(self, s):
       self.__speed = s
    
    def __repr__(self):
        return f'{self.__class__}({self.speed}, {self.height}, {self.angle})'

class Graph:
    __slots__ = ('__coordinates')

    def __init__(self, coord):
        self.__coordinates = coord

    def __repr__(self):
        return f"Graph({self.__coordinates})"

    def create_coordinates_table(self):
        table = '\n  x      y\n'
        for x, y in self.__coordinates:
            table += f'{x:>3}{y:>7.2f}\n'

        return table

--fcc-editable-region--
    def create_trajectory(self):

        rounded_coords = [(round(x), round(y)) for x,y in self.__coordinates]

        return rounded_coords
        
--fcc-editable-region--

ball = Projectile(10, 3, 45)
print(ball)
coordinates = ball.calculate_all_coordinates()
graph = Graph(coordinates)
print(graph.create_trajectory())
   
```
