---
id: 665d949e628d9f3fe305b6e8
title: Step 18
challengeType: 20
dashedName: step-18
---

# --description--

The output is becoming quite difficult to read, so you should replace the `print(graph.create_trajectory())` with a loop that prints each row separately. 

# --hints--

Remove the `print(graph.create_trajectory())` call.

```js
({
    test: () => {
        runPython(`
prnt = _Node(_code).find_calls('print')
assert not any(p.is_equivalent('print(graph.create_trajectory())') for p in prnt), "print still present"
        `)
    }
})
```

You should have a loop that iterates over `graph.create_trajectory()`.

```js
({
    test: () => {
        runPython(`
iter = _Node(_code).find_for_loops()[0].find_for_iter()
assert iter.is_equivalent('graph.create_trajectory()'), "loop is missing"
        `)
    }
})
```

You should print each row in `graph.create_trajectory()`.

```js
({ test: () => runPython(`
loop = _Node(_code).find_for_loops()[0]
var = str(loop.find_for_vars())
assert loop.find_bodies()[0].has_call(f"print({var})")
`) })
```

# --seed--

## --seed-contents--

```py
import math

GRAVITATIONAL_ACCELERATION = 9.81
PROJECTILE = "∙"
x_axis_tick = "T"
y_axis_tick = "⊣"

class Projectile:
    __slots__ = ('__speed', '__height', '__angle')

    def __init__(self, speed, height, angle):
        self.__speed = speed
        self.__height = height
        self.__angle = math.radians(angle)
        
    def __str__(self):
        return f'''
Projectile details:
speed: {self.speed} m/s
height: {self.height} m
angle: {self.angle}°
displacement: {round(self.__calculate_displacement(), 1)} m
'''

    def __calculate_displacement(self):
        horizontal_component = self.__speed * math.cos(self.__angle)
        vertical_component = self.__speed * math.sin(self.__angle)
        squared_component = vertical_component**2
        gh_component = 2 * GRAVITATIONAL_ACCELERATION * self.__height
        sqrt_component = math.sqrt(squared_component + gh_component)
        
        return horizontal_component * (vertical_component + sqrt_component) / GRAVITATIONAL_ACCELERATION
        
    def __calculate_y_coordinate(self, x):
        height_component = self.__height
        angle_component = math.tan(self.__angle) * x
        acceleration_component = GRAVITATIONAL_ACCELERATION * x ** 2 / (
                2 * self.__speed ** 2 * math.cos(self.__angle) ** 2)
        y_coordinate = height_component + angle_component - acceleration_component

        return y_coordinate
    
    def calculate_all_coordinates(self):
        return [
            (x, self.__calculate_y_coordinate(x))
            for x in range(math.ceil(self.__calculate_displacement()))
        ]

    @property
    def height(self):
        return self.__height

    @property
    def angle(self):
        return round(math.degrees(self.__angle))

    @property
    def speed(self):
        return self.__speed

    @height.setter
    def height(self, n):
        self.__height = n

    @angle.setter
    def angle(self, n):
        self.__angle = math.radians(n)

    @speed.setter
    def speed(self, s):
       self.__speed = s
    
    def __repr__(self):
        return f'{self.__class__}({self.speed}, {self.height}, {self.angle})'

class Graph:
    __slots__ = ('__coordinates')

    def __init__(self, coord):
        self.__coordinates = coord

    def __repr__(self):
        return f"Graph({self.__coordinates})"

    def create_coordinates_table(self):
        table = '\n  x      y\n'
        for x, y in self.__coordinates:
            table += f'{x:>3}{y:>7.2f}\n'

        return table

    def create_trajectory(self):
        
        rounded_coords = [(round(x), round(y)) for x,y in self.__coordinates]
        
        x_max = max(rounded_coords, key=lambda i: i[0])[0]
        y_max = max(rounded_coords, key=lambda j: j[1])[1]
        
        matrix_list = [[' ' for _ in range(x_max + 1)] for _ in range(y_max + 1)]

        return matrix_list
        
ball = Projectile(10, 3, 45)
print(ball)
coordinates = ball.calculate_all_coordinates()
graph = Graph(coordinates)
--fcc-editable-region--
print(graph.create_trajectory())
--fcc-editable-region--
```
