---
id: 642e02be7845f13b014cd2b0
title: Step 10
challengeType: 0
dashedName: step-10
---

# --description--

Now that you have a `range` function, you can use it to create a range of letters as well.

Declare a `charRange` function using `const` and arrow syntax. It should take a `start` and `end` parameter. The function should implicitly return the result of calling `range()` with `start` and `end` as the arguments.

# --hints--

You should declare a `charRange` variable.

```js
assert.match(code, /(?:let|const|var)\s+charRange/);
```

Your `charRange` variable should be declared with `const`.

```js
assert.match(code, /const\s+charRange/);
```

Your `charRange` variable should be a function.

```js
assert.isFunction(charRange);
```

Your `charRange` function should use arrow syntax.

```js
assert.match(code, /const\s+charRange\s*=\s*\(.*\)\s*=>/);
```

Your `charRange` function should take `start` as the first parameter.

```js
assert.match(code, /const\s+charRange\s*=\s*\(\s*start/);
```

Your `charRange` function should take `end` as the second parameter.

```js
assert.match(code, /const\s+charRange\s*=\s*\(\s*start\s*,\s*end\s*\)/);
```

Your `charRange` function should use an implicit return.

```js
assert.notMatch(code, /const\s+charRange\s*=\s*\(\s*start\s*,\s*end\s*\)\s*=>\s*{/);
```

Your `charRange` function should call your `range` function.

```js
assert.match(code, /const\s+charRange\s*=\s*\(\s*start\s*,\s*end\s*\)\s*=>\s*range\(/);
```

You should pass `start` and `end` as the arguments to your `range` call.

```js
assert.match(code, /const\s+charRange\s*=\s*\(\s*start\s*,\s*end\s*\)\s*=>\s*range\(\s*start\s*,\s*end\s*\)/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
--fcc-editable-region--

--fcc-editable-region--

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
}
```
