---
id: 6434552bcc0a951a0a99df3b
title: Step 11
challengeType: 0
dashedName: step-11
---

# --description--

Your `range` function expects numbers, but your `start` and `end` values will be strings (specifically, they will be single characters such as `A`).

Convert your `start` and `end` values in your `range()` call to numbers by using the `.charCodeAt()` method on them, passing the number `0` as the argument to that method.

# --hints--

You should use the `.charCodeAt()` method.

```js
assert.match(code, /\.charCodeAt\(/);
```

You should call the `.charCodeAt()` method on `start`.

```js
assert.match(code, /start\.charCodeAt\(/);
```

You should pass `0` to the `.charCodeAt()` method of `start`.

```js
assert.match(code, /start\.charCodeAt\(\s*0\s*\)/);
```

You should call the `.charCodeAt()` method on `end`.

```js
assert.match(code, /end\.charCodeAt\(/);
```

You should pass `0` to the `.charCodeAt()` method of `end`.

```js
assert.match(code, /end\.charCodeAt\(\s*0\s*\)/);
```

You should use the `.charCodeAt()` methods directly in your `range` call.

```js
assert.match(code, /const\s+charRange\s*=\s*\(\s*start\s*,\s*end\s*\)\s*=>\s*range\(\s*start\.charCodeAt\(\s*0\s*\)\s*,\s*end\.charCodeAt\(\s*0\s*\)\s*\)/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
--fcc-editable-region--
const charRange = (start, end) => range(start, end);
--fcc-editable-region--

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
}
```
