---
id: 6434750c53db16218f41e6e1
title: Step 15
challengeType: 0
dashedName: step-15
---

# --description--

Remember that `range()` returns an array, so you can chain array methods directly to the function call.

Call `range()` with `1` and `99` as the arguments, and chain the `.forEach()` method. Pass the `.forEach()` method an empty callback which takes `number` as the parameter.

# --hints--

You should call your `range()` function.

```js
assert.lengthOf(code.match(/range\(/g), 2);
```

You should pass `1` as the first argument to your `range()` call.

```js
assert.match(code, /range\(\s*1/);
```

You should pass `99` as the second argument to your `range()` call.

```js
assert.match(code, /range\(\s*1\s*,\s*99\s*\)/);
```

You should chain the `.forEach()` method to your `range()` call.

```js
assert.match(code, /range\(\s*1\s*,\s*99\s*\)\.forEach\(/);
```

You should pass a callback function to `.forEach()` using arrow syntax.

```js
assert.match(code, /range\(\s*1\s*,\s*99\s*\)\.forEach\(\s*(\([^)]*\)|[^\s()]+)\s*=>/);
```

Your callback function should have `number` as the only parameter.

```js
assert.match(code, /range\(\s*1\s*,\s*99\s*\)\.forEach\(\s*(\(\s*number\s*\)|number)\s*=>/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
  const letters = charRange("A", "J");
  letters.forEach(createLabel);
--fcc-editable-region--

--fcc-editable-region--
}
```
