---
id: 6434759f78ec812264ff8f34
title: Step 16
challengeType: 0
dashedName: step-16
---

# --description--

In your callback, you will need to make two function calls. Start by calling `createLabel()` and pass `number` as the argument. You should see some numbers appear in your spreadsheet.

Then call the `.forEach()` method on your `letters` array. Pass an empty callback function which takes a `letter` parameter.

# --hints--

You should call your `createLabel()` function.

```js
assert.match(code, /range\(\s*1\s*,\s*99\s*\)\.forEach\(\s*(\(\s*number\s*\)|number)\s*=>\s*\{\s*createLabel\(/);
```

You should pass `number` to your `createLabel()` call.

```js
assert.match(code, /range\(\s*1\s*,\s*99\s*\)\.forEach\(\s*(\(\s*number\s*\)|number)\s*=>\s*\{\s*createLabel\(/)
```

You should call the `.forEach()` method on your `letters` array.

```js
assert.lengthOf(code.match(/letters\.forEach\(/g), 2)
```

You should pass a callback function with arrow syntax to your `.forEach()` method.

```js
assert.match(code, /letters\.forEach\(\s*(\([^)]*\)|[^\s()]+)\s*=>\s*\{/)
```

Your callback function should have a `letter` parameter.

```js
assert.match(code, /letters\.forEach\(\s*(\(\s*letter\s*\)|letter)\s*=>\s*\{/)
```

Your callback function should be empty.

```js
assert.match(code, /letters\.forEach\(\s*(\(\s*letter\s*\)|letter)\s*=>\s*\{\s*\}/)
```

Your `letters.forEach()` callback function should be nested inside the `range(1, 99).forEach(number => {}` callback function.

```js
assert.match(code, /range\s*\(\s*1\s*,\s*99\s*\)\s*.forEach\s*\(\s*(\(\s*number\s*\)|number)\s*=>\s*\{\s*[^}]*letters\.forEach\(\s*(\(\s*letter\s*\)|letter)\s*=>\s*\{\s*\}\s*\)\s*;?\s*\}\s*\)/)
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
  const letters = charRange("A", "J");
  letters.forEach(createLabel);
--fcc-editable-region--
  range(1, 99).forEach(number => {

  })
--fcc-editable-region--
}
```
