---
id: 6437124c4c03dd4c8fb35d56
title: Step 21
challengeType: 0
dashedName: step-21
---

# --description--

Declare an `isEven` function, which takes a `num` parameter and returns `true` if the number is even, and `false` otherwise. Use the modulo operator `%` to determine if a number is even or odd.

# --hints--

You should declare an `isEven` variable.

```js
assert.match(code, /(?:let|const|var)\s+isEven/);
```

You should use `const` to declare your `isEven` variable.

```js
assert.match(code, /const\s+isEven/);
```

Your `isEven` variable should be a function.

```js
assert.isFunction(isEven);
```

Your `isEven` function should use arrow syntax.

```js
assert.match(code, /const\s+isEven\s*=\s*(\([^)]*\)|[^\s()]+)\s*=>/);
```

Your `isEven` function should have a `num` parameter.

```js
assert.match(code, /const\s+isEven\s*=\s*(\(\s*num\s*\)|num)\s*=>/);
```

Your `isEven` function should use the modulo operator `%`.

```js
assert.match(isEven.toString(),  /%/);
```

Your `isEven` function should return `true` for even numbers.

```js
assert.isTrue(isEven(2));
assert.isTrue(isEven(1000));
assert.isTrue(isEven(42));
```

Your `isEven` function should return `false` for odd numbers.

```js
assert.isFalse(isEven(1));
assert.isFalse(isEven(333));
assert.isFalse(isEven(777777777));
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
--fcc-editable-region--

--fcc-editable-region--
const sum = nums => nums.reduce((acc, el) => acc + el, 0);

const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
  const letters = charRange("A", "J");
  letters.forEach(createLabel);
  range(1, 99).forEach(number => {
    createLabel(number);
    letters.forEach(letter => {
      const input = document.createElement("input");
      input.type = "text";
      input.id = letter + number;
      input.ariaLabel = letter + number;
      container.appendChild(input);
    })
  })
}
```
