---
id: 643715013330824ecaa70442
title: Step 23
challengeType: 0
dashedName: step-23
---

# --description--

Your next function will calculate the median value of an array of numbers. Start by declaring a `median` arrow function that takes a `nums` parameter.

In the function, declare a `sorted` variable and assign it the value of sorting a copy of the `nums` array.

You should use the `slice()` method for creating a shallow copy of the array.

# --hints--

You should declare a `median` variable.

```js
assert.match(code, /(?:let|const|var)\s+median/);
```

You should use `const` to declare your `median` variable.

```js
assert.match(code, /const\s+median/);
```

Your `median` variable should be a function.

```js
assert.isFunction(median);
```

Your `median` function should use arrow syntax.

```js
assert.match(code, /const\s+median\s*=\s*\(?/);
```

Your `median` function should have a `nums` parameter.

```js
assert.match(code, /const\s+median\s*=\s*(\(\s*nums\s*\)|nums)/);
```

Your `median` function should not use an implicit return.

```js
assert.match(code, /const\s+median\s*=\s*(\(\s*nums\s*\)|nums)\s*=>\s*\{/);
```

Your `median` function should have a `sorted` variable.

```js
assert.match(code, /const\s+median\s*=\s*(\(\s*nums\s*\)|nums)\s*=>\s*\{\s*(?:let|var|const)\s+sorted/);
```

You should use `const` to declare your `sorted` variable.

```js
assert.match(code, /const\s+median\s*=\s*(\(\s*nums\s*\)|nums)\s*=>\s*\{\s*const\s+sorted/);
```

You should use `.slice()` to assign a copy of the `nums` array to `sorted`.

```js
assert.match(code, /const\s+median\s*=\s*(\(\s*nums\s*\)|nums)\s*=>\s*\{\s*const\s+sorted\s*=\s*nums\.slice\(\s*\)/);
```

You should chain the `.sort()` method to your `.slice()` method.

```js
assert.match(code, /const\s+median\s*=\s*(\(\s*nums\s*\)|nums)\s*=>\s*\{\s*const\s+sorted\s*=\s*nums\.slice\(\s*\)\.sort\(/);
```

You should pass a callback function to your `sort` method to accurately sort the numbers in ascending order. Use an implicit return for clarity.

```js
assert.match(code, /const\s+median\s*=\s*(\(\s*nums\s*\)|nums)\s*=>\s*\{\s*const\s+sorted\s*=\s*nums\.slice\(\s*\)\.sort\(\s*\(\s*a\s*,\s*b\s*\)\s*=>\s*a\s*-\s*b\s*\)\s*\s*;?\s*\}/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const isEven = num => num % 2 === 0;
const sum = nums => nums.reduce((acc, el) => acc + el, 0);
const average = nums => sum(nums) / nums.length;

--fcc-editable-region--

--fcc-editable-region--

const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
  const letters = charRange("A", "J");
  letters.forEach(createLabel);
  range(1, 99).forEach(number => {
    createLabel(number);
    letters.forEach(letter => {
      const input = document.createElement("input");
      input.type = "text";
      input.id = letter + number;
      input.ariaLabel = letter + number;
      container.appendChild(input);
    })
  })
}
```
