---
id: 6449749d20436c1f1dfadcf2
title: Step 28
challengeType: 0
dashedName: step-28
---

# --description--

In your `window.onload` function, you need to tell your `input` elements to call the `update` function when the value changes. You can do this by directly setting the `onchange` property.

Set the `onchange` property to be a reference to your `update` function.

# --hints--

Your `window.onload` function should access the `onchange` property of the `input` element.

```js
assert.match(window.onload.toString(), /input\.onchange/);
```

Your `window.onload` function should set the `onchange` property to `update`.

```js
assert.match(window.onload.toString(), /input\.onchange\s*=\s*update/);
```

Your `window.onload` function should not call your `update` function.

```js
assert.notMatch(window.onload.toString(), /update\(\s*\)/);
```

Your `input` elements should all have your `update` function as the `onchange` property.

```js
const inputs = document.querySelectorAll('input');
inputs.forEach(input => {
  assert.property(input, 'onchange');
  assert.equal(input.onchange, update);
})
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const isEven = num => num % 2 === 0;
const sum = nums => nums.reduce((acc, el) => acc + el, 0);
const average = nums => sum(nums) / nums.length;

const median = nums => {
  const sorted = nums.slice().sort((a, b) => a - b);
  const length = sorted.length;
  const middle = length / 2 - 1;
  return isEven(length)
    ? average([sorted[middle], sorted[middle + 1]])
    : sorted[Math.ceil(middle)];
}

const spreadsheetFunctions = {
  sum,
  average,
  median
}

const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
  const letters = charRange("A", "J");
  letters.forEach(createLabel);
  range(1, 99).forEach(number => {
    createLabel(number);
    letters.forEach(letter => {
      const input = document.createElement("input");
      input.type = "text";
      input.id = letter + number;
      input.ariaLabel = letter + number;
--fcc-editable-region--

--fcc-editable-region--
      container.appendChild(input);
    })
  })
}

const update = event => {

}
```
