---
id: 6449755666005520330cec5b
title: Step 29
challengeType: 0
dashedName: step-29
---

# --description--

Since your `update` event is running as a `change` event listener, the `event` parameter will be a change event.

The `target` property of the change event represents the element that changed. Assign the `target` property to a new variable called `element`.

# --hints--

You should declare an `element` variable in your `update` function.

```js
assert.match(code, /const\s+update\s*=\s*(\(\s*event\s*\)|event)\s*=>\s*\{\s*(?:var|let|const)\s+element/);
```

You should use `const` to declare your `element` variable.

```js
assert.match(code, /const\s+update\s*=\s*(\(?\s*event\s*\)|event)\s*=>\s*\{\s*const\s+element/);
```

You should assign the `target` property of the `event` parameter to your `element` variable.

```js
assert.match(code, /const\s+update\s*=\s*(\(\s*event\s*\)|event)\s*=>\s*\{\s*const\s+element\s*=\s*event\.target/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const isEven = num => num % 2 === 0;
const sum = nums => nums.reduce((acc, el) => acc + el, 0);
const average = nums => sum(nums) / nums.length;

const median = nums => {
  const sorted = nums.slice().sort((a, b) => a - b);
  const length = sorted.length;
  const middle = length / 2 - 1;
  return isEven(length)
    ? average([sorted[middle], sorted[middle + 1]])
    : sorted[Math.ceil(middle)];
}

const spreadsheetFunctions = {
  sum,
  average,
  median
}

const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
  const letters = charRange("A", "J");
  letters.forEach(createLabel);
  range(1, 99).forEach(number => {
    createLabel(number);
    letters.forEach(letter => {
      const input = document.createElement("input");
      input.type = "text";
      input.id = letter + number;
      input.ariaLabel = letter + number;
      input.onchange = update;
      container.appendChild(input);
    })
  })
}

--fcc-editable-region--
const update = event => {

}
--fcc-editable-region--
```
