---
id: 64497da4062602213ecf32e7
title: Step 30
challengeType: 0
dashedName: step-30
---

# --description--

Because the `change` event is triggering on an `input` element, the element will have a `value` property that represents the current value of the input.

Assign the `value` property of `element` to a new variable called `value`, and use `.replace()` to remove all whitespace.

# --hints--

You should declare a `value` variable after your `element` variable.

```js
assert.match(code, /const\s+update\s*=\s*(\(\s*event\s*\)|event)\s*=>\s*\{\s*const\s+element\s*=\s*event\.target\s*;?\s*(?:const|let|var)\s+value/);
```

You should use `const` to declare your `value` variable.

```js
assert.match(code, /const\s+update\s*=\s*(\(\s*event\s*\)|event)\s*=>\s*\{\s*const\s+element\s*=\s*event\.target\s*;?\s*const\s+value/);
```

You should assign the `value` property of `element` to your `value` variable.

```js
assert.match(code, /const\s+update\s*=\s*(\(\s*event\s*\)|event)\s*=>\s*\{\s*const\s+element\s*=\s*event\.target\s*;?\s*const\s+value\s*=\s*element\.value/);
```

You should call the `.replace()` method on the `value` property of the `element`.

```js
assert.match(code, /const\s+update\s*=\s*(\(\s*event\s*\)|event)\s*=>\s*\{\s*const\s+element\s*=\s*event\.target\s*;?\s*const\s+value\s*=\s*element\.value\.replace\(/);
```

You should pass a regular expression to match whitespace to your `.replace()` method. Use the `\s` character class.

```js
assert.match(code, /const\s+update\s*=\s*(\(\s*event\s*\)|event)\s*=>\s*\{\s*const\s+element\s*=\s*event\.target\s*;?\s*const\s+value\s*=\s*element\.value\.replace\(\s*\/\\s\//);
```

You should make your regular expression global.

```js
assert.match(code, /const\s+update\s*=\s*(\(\s*event\s*\)|event)\s*=>\s*\{\s*const\s+element\s*=\s*event\.target\s*;?\s*const\s+value\s*=\s*element\.value\.replace\(\s*\/\\s\/g/);
```

You should pass an empty string as your second argument to the `.replace()` method.

```js
assert.match(code, /const\s+update\s*=\s*(?:\(\s*event\s*\)|event)\s*=>\s*\{\s*const\s+element\s*=\s*event\.target\s*;?\s*const\s+value\s*=\s*element\.value\.replace\(\s*\/\\s\/g\s*,\s*('|"|`)\1/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const isEven = num => num % 2 === 0;
const sum = nums => nums.reduce((acc, el) => acc + el, 0);
const average = nums => sum(nums) / nums.length;

const median = nums => {
  const sorted = nums.slice().sort((a, b) => a - b);
  const length = sorted.length;
  const middle = length / 2 - 1;
  return isEven(length)
    ? average([sorted[middle], sorted[middle + 1]])
    : sorted[Math.ceil(middle)];
}

const spreadsheetFunctions = {
  sum,
  average,
  median
}

const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
  const letters = charRange("A", "J");
  letters.forEach(createLabel);
  range(1, 99).forEach(number => {
    createLabel(number);
    letters.forEach(letter => {
      const input = document.createElement("input");
      input.type = "text";
      input.id = letter + number;
      input.ariaLabel = letter + number;
      input.onchange = update;
      container.appendChild(input);
    })
  })
}

--fcc-editable-region--
const update = event => {
  const element = event.target;

}
--fcc-editable-region--
```
