---
id: 646d3e64b15f92be6e61704e
title: Step 70
challengeType: 0
dashedName: step-70
---

# --description--

The `regex` you will be passing to your `infixEval` function will match two numbers with an operator between them. The first number will be assigned to `arg1` in the callback, the second to `arg2`, and the operator to `operator`.

Have your callback function implicitly return the `operator` property of your `infixToFunction` object. Remember that `operator` is a variable which holds the property name, not the actual property name.

# --hints--

Your callback should use an implicit return.

```js
assert.notMatch(code, /const\s+infixEval\s*=\s*\(\s*str\s*,\s*regex\s*\)\s*=>\s*str\.replace\(\s*regex\s*,\s*\(\s*_match\s*,\s*arg1\s*,\s*operator\s*,\s*arg2\s*\)\s*=>\s*\{/);
```

Your callback function should access the `infixToFunction` object.

```js
assert.match(code, /const\s+infixEval\s*=\s*\(\s*str\s*,\s*regex\s*\)\s*=>\s*str\.replace\(\s*regex\s*,\s*\(\s*_match\s*,\s*arg1\s*,\s*operator\s*,\s*arg2\s*\)\s*=>\s*infixToFunction/);
```

Your callback function should use bracket notation to access the property of the `infixToFunction` object that matches the value of the `operator` parameter.

```js
assert.match(code, /const\s+infixEval\s*=\s*\(\s*str\s*,\s*regex\s*\)\s*=>\s*str\.replace\(\s*regex\s*,\s*\(\s*_match\s*,\s*arg1\s*,\s*operator\s*,\s*arg2\s*\)\s*=>\s*infixToFunction\s*\[\s*operator\s*\]\s*\)/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const infixToFunction = {
  "+": (x, y) => x + y,
  "-": (x, y) => x - y,
  "*": (x, y) => x * y,
  "/": (x, y) => x / y,
}

--fcc-editable-region--
const infixEval = (str, regex) => str.replace(regex, (_match, arg1, operator, arg2) => {});
--fcc-editable-region--

const isEven = num => num % 2 === 0;
const sum = nums => nums.reduce((acc, el) => acc + el, 0);
const average = nums => sum(nums) / nums.length;

const median = nums => {
  const sorted = nums.slice().sort((a, b) => a - b);
  const length = sorted.length;
  const middle = length / 2 - 1;
  return isEven(length)
    ? average([sorted[middle], sorted[middle + 1]])
    : sorted[Math.ceil(middle)];
}

const spreadsheetFunctions = {
  sum,
  average,
  median
}

const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

const evalFormula = (x, cells) => {
  const idToText = id => cells.find(cell => cell.id === id).value;
  const rangeRegex = /([A-J])([1-9][0-9]?):([A-J])([1-9][0-9]?)/gi;
  const rangeFromString = (num1, num2) => range(parseInt(num1), parseInt(num2));
  const elemValue = num => character => idToText(character + num);
  const addCharacters = character1 => character2 => num => charRange(character1, character2).map(elemValue(num));
  const rangeExpanded = x.replace(rangeRegex, (_match, char1, num1, char2, num2) => rangeFromString(num1, num2).map(addCharacters(char1)(char2)));
  const cellRegex = /[A-J][1-9][0-9]?/gi;
  const cellExpanded = rangeExpanded.replace(cellRegex, match => idToText(match.toUpperCase()));
}

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
  const letters = charRange("A", "J");
  letters.forEach(createLabel);
  range(1, 99).forEach(number => {
    createLabel(number);
    letters.forEach(letter => {
      const input = document.createElement("input");
      input.type = "text";
      input.id = letter + number;
      input.ariaLabel = letter + number;
      input.onchange = update;
      container.appendChild(input);
    })
  })
}

const update = event => {
  const element = event.target;
  const value = element.value.replace(/\s/g, "");
  if (!value.includes(element.id) && value.startsWith('=')) {

  }
}
```
