---
id: 646d4717a689e1cfa232e357
title: Step 92
challengeType: 0
dashedName: step-92
---

# --description--

Like you did with your `highPrecedence()` function, your `evalFormula()` function needs to ensure it has evaluated and replaced everything.

Use a ternary to check if `functionExpanded` is equal to the original string `x`. If it is, return `functionExpanded`, otherwise return the result of calling `evalFormula()` again with `functionExpanded` and `cells` as arguments.

# --hints--

Your `evalFormula` function should use the `return` keyword.

```js
assert.match(code, /const\s+evalFormula\s*=\s*\(\s*x\s*,\s*cells\s*\)\s*=>\s*{\s*const\s+idToText\s*=\s*(\(\s*id\s*\)|id)\s*=>\s*cells\.find\(\s*(\(\s*cell\s*\)|cell)\s*=>\s*(?:cell\.id\s*===\s*id|id\s*===\s*cell\.id)\s*\)\.value\s*;?\s*const\s+rangeRegex\s*=\s*\/\(\[A-J\]\)\(\[1-9\]\[0-9\]\?\):\(\[A-J\]\)\(\[1-9\]\[0-9\]\?\)\/(gi|ig)\s*;?\s*const\s+rangeFromString\s*=\s*\(\s*num1\s*,\s*num2\s*\)\s*=>\s*range\(\s*parseInt\(\s*num1\s*\)\s*,\s*parseInt\(\s*num2\s*\)\s*\)\s*;?\s*const\s+elemValue\s*=\s*(\(\s*num\s*\)|num)\s*=>\s*(\(\s*character\s*\)|character)\s*=>\s*idToText\(\s*character\s*\+\s*num\s*\)\s*;?\s*const\s+addCharacters\s*=\s*(\(\s*character1\s*\)|character1)\s*=>\s*(\(\s*character2\s*\)|character2)\s*=>\s*(\(\s*num\s*\)|num)\s*=>\s*charRange\(\s*character1\s*,\s*character2\s*\)\.map\(\s*elemValue\(\s*num\s*\)\s*\)\s*;?\s*const\s+rangeExpanded\s*=\s*x\.replace\(\s*rangeRegex\s*,\s*\(\s*_match\s*,\s*char1\s*,\s*num1\s*,\s*char2\s*,\s*num2\s*\)\s*=>\s*rangeFromString\(\s*num1\s*,\s*num2\s*\)\.map\(\s*addCharacters\s*\(\s*char1\s*\)\(\s*char2\s*\)\s*\)\s*\)\s*;?\s*const\s+cellRegex\s*=\s*\/\[A-J\]\[1-9\]\[0-9\]\?\/(gi|ig)\s*;?\s*const\s+cellExpanded\s*=\s*rangeExpanded\.replace\(\s*cellRegex\s*,\s*(\(\s*match\s*\)|match)\s*=>\s*idToText\(\s*match\.toUpperCase\(\s*\)\s*\)\s*\)\s*;?\s*(?:const|let|var)\s+functionExpanded\s*=\s*applyFunction\(\s*cellExpanded\s*\)\s*;?\s*return/);
```

Your `return` statement should check if `functionExpanded` is equal to `x`.

```js
assert.match(code, /const\s+evalFormula\s*=\s*\(\s*x\s*,\s*cells\s*\)\s*=>\s*{\s*const\s+idToText\s*=\s*(\(\s*id\s*\)|id)\s*=>\s*cells\.find\(\s*(\(\s*cell\s*\)|cell)\s*=>\s*(?:cell\.id\s*===\s*id|id\s*===\s*cell\.id)\s*\)\.value\s*;?\s*const\s+rangeRegex\s*=\s*\/\(\[A-J\]\)\(\[1-9\]\[0-9\]\?\):\(\[A-J\]\)\(\[1-9\]\[0-9\]\?\)\/(gi|ig)\s*;?\s*const\s+rangeFromString\s*=\s*\(\s*num1\s*,\s*num2\s*\)\s*=>\s*range\(\s*parseInt\(\s*num1\s*\)\s*,\s*parseInt\(\s*num2\s*\)\s*\)\s*;?\s*const\s+elemValue\s*=\s*(\(\s*num\s*\)|num)\s*=>\s*(\(\s*character\s*\)|character)\s*=>\s*idToText\(\s*character\s*\+\s*num\s*\)\s*;?\s*const\s+addCharacters\s*=\s*(\(\s*character1\s*\)|character1)\s*=>\s*(\(\s*character2\s*\)|character2)\s*=>\s*(\(\s*num\s*\)|num)\s*=>\s*charRange\(\s*character1\s*,\s*character2\s*\)\.map\(\s*elemValue\(\s*num\s*\)\s*\)\s*;?\s*const\s+rangeExpanded\s*=\s*x\.replace\(\s*rangeRegex\s*,\s*\(\s*_match\s*,\s*char1\s*,\s*num1\s*,\s*char2\s*,\s*num2\s*\)\s*=>\s*rangeFromString\(\s*num1\s*,\s*num2\s*\)\.map\(\s*addCharacters\s*\(\s*char1\s*\)\(\s*char2\s*\)\s*\)\s*\)\s*;?\s*const\s+cellRegex\s*=\s*\/\[A-J\]\[1-9\]\[0-9\]\?\/(gi|ig)\s*;?\s*const\s+cellExpanded\s*=\s*rangeExpanded\.replace\(\s*cellRegex\s*,\s*(\(\s*match\s*\)|match)\s*=>\s*idToText\(\s*match\.toUpperCase\(\s*\)\s*\)\s*\)\s*;?\s*(?:const|let|var)\s+functionExpanded\s*=\s*applyFunction\(\s*cellExpanded\s*\)\s*;?\s*return\s+(?:functionExpanded\s*===\s*x|x\s*===\s*functionExpanded)/);
```

Your `return` statement should use a ternary operator.

```js
assert.match(code, /const\s+evalFormula\s*=\s*\(\s*x\s*,\s*cells\s*\)\s*=>\s*{\s*const\s+idToText\s*=\s*(\(\s*id\s*\)|id)\s*=>\s*cells\.find\(\s*(\(\s*cell\s*\)|cell)\s*=>\s*(?:cell\.id\s*===\s*id|id\s*===\s*cell\.id)\s*\)\.value\s*;?\s*const\s+rangeRegex\s*=\s*\/\(\[A-J\]\)\(\[1-9\]\[0-9\]\?\):\(\[A-J\]\)\(\[1-9\]\[0-9\]\?\)\/(gi|ig)\s*;?\s*const\s+rangeFromString\s*=\s*\(\s*num1\s*,\s*num2\s*\)\s*=>\s*range\(\s*parseInt\(\s*num1\s*\)\s*,\s*parseInt\(\s*num2\s*\)\s*\)\s*;?\s*const\s+elemValue\s*=\s*(\(\s*num\s*\)|num)\s*=>\s*(\(\s*character\s*\)|character)\s*=>\s*idToText\(\s*character\s*\+\s*num\s*\)\s*;?\s*const\s+addCharacters\s*=\s*(\(\s*character1\s*\)|character1)\s*=>\s*(\(\s*character2\s*\)|character2)\s*=>\s*(\(\s*num\s*\)|num)\s*=>\s*charRange\(\s*character1\s*,\s*character2\s*\)\.map\(\s*elemValue\(\s*num\s*\)\s*\)\s*;?\s*const\s+rangeExpanded\s*=\s*x\.replace\(\s*rangeRegex\s*,\s*\(\s*_match\s*,\s*char1\s*,\s*num1\s*,\s*char2\s*,\s*num2\s*\)\s*=>\s*rangeFromString\(\s*num1\s*,\s*num2\s*\)\.map\(\s*addCharacters\s*\(\s*char1\s*\)\(\s*char2\s*\)\s*\)\s*\)\s*;?\s*const\s+cellRegex\s*=\s*\/\[A-J\]\[1-9\]\[0-9\]\?\/(gi|ig)\s*;?\s*const\s+cellExpanded\s*=\s*rangeExpanded\.replace\(\s*cellRegex\s*,\s*(\(\s*match\s*\)|match)\s*=>\s*idToText\(\s*match\.toUpperCase\(\s*\)\s*\)\s*\)\s*;?\s*(?:const|let|var)\s+functionExpanded\s*=\s*applyFunction\(\s*cellExpanded\s*\)\s*;?\s*return\s+(?:functionExpanded\s*===\s*x|x\s*===\s*functionExpanded)\s*\?/);
```

If the ternary condition is true, your `evalFormula()` should return `functionExpanded`.

```js
assert.match(code, /const\s+evalFormula\s*=\s*\(\s*x\s*,\s*cells\s*\)\s*=>\s*{\s*const\s+idToText\s*=\s*(\(\s*id\s*\)|id)\s*=>\s*cells\.find\(\s*(\(\s*cell\s*\)|cell)\s*=>\s*(?:cell\.id\s*===\s*id|id\s*===\s*cell\.id)\s*\)\.value\s*;?\s*const\s+rangeRegex\s*=\s*\/\(\[A-J\]\)\(\[1-9\]\[0-9\]\?\):\(\[A-J\]\)\(\[1-9\]\[0-9\]\?\)\/(gi|ig)\s*;?\s*const\s+rangeFromString\s*=\s*\(\s*num1\s*,\s*num2\s*\)\s*=>\s*range\(\s*parseInt\(\s*num1\s*\)\s*,\s*parseInt\(\s*num2\s*\)\s*\)\s*;?\s*const\s+elemValue\s*=\s*(\(\s*num\s*\)|num)\s*=>\s*(\(\s*character\s*\)|character)\s*=>\s*idToText\(\s*character\s*\+\s*num\s*\)\s*;?\s*const\s+addCharacters\s*=\s*(\(\s*character1\s*\)|character1)\s*=>\s*(\(\s*character2\s*\)|character2)\s*=>\s*(\(\s*num\s*\)|num)\s*=>\s*charRange\(\s*character1\s*,\s*character2\s*\)\.map\(\s*elemValue\(\s*num\s*\)\s*\)\s*;?\s*const\s+rangeExpanded\s*=\s*x\.replace\(\s*rangeRegex\s*,\s*\(\s*_match\s*,\s*char1\s*,\s*num1\s*,\s*char2\s*,\s*num2\s*\)\s*=>\s*rangeFromString\(\s*num1\s*,\s*num2\s*\)\.map\(\s*addCharacters\s*\(\s*char1\s*\)\(\s*char2\s*\)\s*\)\s*\)\s*;?\s*const\s+cellRegex\s*=\s*\/\[A-J\]\[1-9\]\[0-9\]\?\/(gi|ig)\s*;?\s*const\s+cellExpanded\s*=\s*rangeExpanded\.replace\(\s*cellRegex\s*,\s*(\(\s*match\s*\)|match)\s*=>\s*idToText\(\s*match\.toUpperCase\(\s*\)\s*\)\s*\)\s*;?\s*(?:const|let|var)\s+functionExpanded\s*=\s*applyFunction\(\s*cellExpanded\s*\)\s*;?\s*return\s+(?:functionExpanded\s*===\s*x|x\s*===\s*functionExpanded)\s*\?\s*functionExpanded/);
```

If the ternary condition is false, your `evalFormula()` should return the result of calling `evalFormula()`.

```js
assert.match(code, /const\s+evalFormula\s*=\s*\(\s*x\s*,\s*cells\s*\)\s*=>\s*{\s*const\s+idToText\s*=\s*(\(\s*id\s*\)|id)\s*=>\s*cells\.find\(\s*(\(\s*cell\s*\)|cell)\s*=>\s*(?:cell\.id\s*===\s*id|id\s*===\s*cell\.id)\s*\)\.value\s*;?\s*const\s+rangeRegex\s*=\s*\/\(\[A-J\]\)\(\[1-9\]\[0-9\]\?\):\(\[A-J\]\)\(\[1-9\]\[0-9\]\?\)\/(gi|ig)\s*;?\s*const\s+rangeFromString\s*=\s*\(\s*num1\s*,\s*num2\s*\)\s*=>\s*range\(\s*parseInt\(\s*num1\s*\)\s*,\s*parseInt\(\s*num2\s*\)\s*\)\s*;?\s*const\s+elemValue\s*=\s*(\(\s*num\s*\)|num)\s*=>\s*(\(\s*character\s*\)|character)\s*=>\s*idToText\(\s*character\s*\+\s*num\s*\)\s*;?\s*const\s+addCharacters\s*=\s*(\(\s*character1\s*\)|character1)\s*=>\s*(\(\s*character2\s*\)|character2)\s*=>\s*(\(\s*num\s*\)|num)\s*=>\s*charRange\(\s*character1\s*,\s*character2\s*\)\.map\(\s*elemValue\(\s*num\s*\)\s*\)\s*;?\s*const\s+rangeExpanded\s*=\s*x\.replace\(\s*rangeRegex\s*,\s*\(\s*_match\s*,\s*char1\s*,\s*num1\s*,\s*char2\s*,\s*num2\s*\)\s*=>\s*rangeFromString\(\s*num1\s*,\s*num2\s*\)\.map\(\s*addCharacters\s*\(\s*char1\s*\)\(\s*char2\s*\)\s*\)\s*\)\s*;?\s*const\s+cellRegex\s*=\s*\/\[A-J\]\[1-9\]\[0-9\]\?\/(gi|ig)\s*;?\s*const\s+cellExpanded\s*=\s*rangeExpanded\.replace\(\s*cellRegex\s*,\s*(\(\s*match\s*\)|match)\s*=>\s*idToText\(\s*match\.toUpperCase\(\s*\)\s*\)\s*\)\s*;?\s*(?:const|let|var)\s+functionExpanded\s*=\s*applyFunction\(\s*cellExpanded\s*\)\s*;?\s*return\s+(?:functionExpanded\s*===\s*x|x\s*===\s*functionExpanded)\s*\?\s*functionExpanded\s*:\s*evalFormula\(/);
```

You should pass `functionExpanded` as the first argument to your `evalFormula()` call.

```js
assert.match(code, /const\s+evalFormula\s*=\s*\(\s*x\s*,\s*cells\s*\)\s*=>\s*{\s*const\s+idToText\s*=\s*(\(\s*id\s*\)|id)\s*=>\s*cells\.find\(\s*(\(\s*cell\s*\)|cell)\s*=>\s*(?:cell\.id\s*===\s*id|id\s*===\s*cell\.id)\s*\)\.value\s*;?\s*const\s+rangeRegex\s*=\s*\/\(\[A-J\]\)\(\[1-9\]\[0-9\]\?\):\(\[A-J\]\)\(\[1-9\]\[0-9\]\?\)\/(gi|ig)\s*;?\s*const\s+rangeFromString\s*=\s*\(\s*num1\s*,\s*num2\s*\)\s*=>\s*range\(\s*parseInt\(\s*num1\s*\)\s*,\s*parseInt\(\s*num2\s*\)\s*\)\s*;?\s*const\s+elemValue\s*=\s*(\(\s*num\s*\)|num)\s*=>\s*(\(\s*character\s*\)|character)\s*=>\s*idToText\(\s*character\s*\+\s*num\s*\)\s*;?\s*const\s+addCharacters\s*=\s*(\(\s*character1\s*\)|character1)\s*=>\s*(\(\s*character2\s*\)|character2)\s*=>\s*(\(\s*num\s*\)|num)\s*=>\s*charRange\(\s*character1\s*,\s*character2\s*\)\.map\(\s*elemValue\(\s*num\s*\)\s*\)\s*;?\s*const\s+rangeExpanded\s*=\s*x\.replace\(\s*rangeRegex\s*,\s*\(\s*_match\s*,\s*char1\s*,\s*num1\s*,\s*char2\s*,\s*num2\s*\)\s*=>\s*rangeFromString\(\s*num1\s*,\s*num2\s*\)\.map\(\s*addCharacters\s*\(\s*char1\s*\)\(\s*char2\s*\)\s*\)\s*\)\s*;?\s*const\s+cellRegex\s*=\s*\/\[A-J\]\[1-9\]\[0-9\]\?\/(gi|ig)\s*;?\s*const\s+cellExpanded\s*=\s*rangeExpanded\.replace\(\s*cellRegex\s*,\s*(\(\s*match\s*\)|match)\s*=>\s*idToText\(\s*match\.toUpperCase\(\s*\)\s*\)\s*\)\s*;?\s*(?:const|let|var)\s+functionExpanded\s*=\s*applyFunction\(\s*cellExpanded\s*\)\s*;?\s*return\s+(?:functionExpanded\s*===\s*x|x\s*===\s*functionExpanded)\s*\?\s*functionExpanded\s*:\s*evalFormula\(\s*functionExpanded/);
```

You should pass `cells` as the second argument to your `evalFormula()` call.

```js
assert.match(code, /const\s+evalFormula\s*=\s*\(\s*x\s*,\s*cells\s*\)\s*=>\s*{\s*const\s+idToText\s*=\s*(\(\s*id\s*\)|id)\s*=>\s*cells\.find\(\s*(\(\s*cell\s*\)|cell)\s*=>\s*(?:cell\.id\s*===\s*id|id\s*===\s*cell\.id)\s*\)\.value\s*;?\s*const\s+rangeRegex\s*=\s*\/\(\[A-J\]\)\(\[1-9\]\[0-9\]\?\):\(\[A-J\]\)\(\[1-9\]\[0-9\]\?\)\/(gi|ig)\s*;?\s*const\s+rangeFromString\s*=\s*\(\s*num1\s*,\s*num2\s*\)\s*=>\s*range\(\s*parseInt\(\s*num1\s*\)\s*,\s*parseInt\(\s*num2\s*\)\s*\)\s*;?\s*const\s+elemValue\s*=\s*(\(\s*num\s*\)|num)\s*=>\s*(\(\s*character\s*\)|character)\s*=>\s*idToText\(\s*character\s*\+\s*num\s*\)\s*;?\s*const\s+addCharacters\s*=\s*(\(\s*character1\s*\)|character1)\s*=>\s*(\(\s*character2\s*\)|character2)\s*=>\s*(\(\s*num\s*\)|num)\s*=>\s*charRange\(\s*character1\s*,\s*character2\s*\)\.map\(\s*elemValue\(\s*num\s*\)\s*\)\s*;?\s*const\s+rangeExpanded\s*=\s*x\.replace\(\s*rangeRegex\s*,\s*\(\s*_match\s*,\s*char1\s*,\s*num1\s*,\s*char2\s*,\s*num2\s*\)\s*=>\s*rangeFromString\(\s*num1\s*,\s*num2\s*\)\.map\(\s*addCharacters\s*\(\s*char1\s*\)\(\s*char2\s*\)\s*\)\s*\)\s*;?\s*const\s+cellRegex\s*=\s*\/\[A-J\]\[1-9\]\[0-9\]\?\/(gi|ig)\s*;?\s*const\s+cellExpanded\s*=\s*rangeExpanded\.replace\(\s*cellRegex\s*,\s*(\(\s*match\s*\)|match)\s*=>\s*idToText\(\s*match\.toUpperCase\(\s*\)\s*\)\s*\)\s*;?\s*(?:const|let|var)\s+functionExpanded\s*=\s*applyFunction\(\s*cellExpanded\s*\)\s*;?\s*return\s+(?:functionExpanded\s*===\s*x|x\s*===\s*functionExpanded)\s*\?\s*functionExpanded\s*:\s*evalFormula\(\s*functionExpanded\s*,\s*cells\s*\)\s*;?/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <title>Functional Programming Spreadsheet</title>
  </head>
  <body>
    <div id="container">
      <div></div>
    </div>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
#container {
  display: grid;
  grid-template-columns: 50px repeat(10, 200px);
  grid-template-rows: repeat(11, 30px);
}

.label {
  background-color: lightgray;
  text-align: center;
  vertical-align: middle;
  line-height: 30px;
}
```

```js
const infixToFunction = {
  "+": (x, y) => x + y,
  "-": (x, y) => x - y,
  "*": (x, y) => x * y,
  "/": (x, y) => x / y,
}

const infixEval = (str, regex) => str.replace(regex, (_match, arg1, operator, arg2) => infixToFunction[operator](parseFloat(arg1), parseFloat(arg2)));

const highPrecedence = str => {
  const regex = /([\d.]+)([*\/])([\d.]+)/;
  const str2 = infixEval(str, regex);
  return str === str2 ? str : highPrecedence(str2);
}

const isEven = num => num % 2 === 0;
const sum = nums => nums.reduce((acc, el) => acc + el, 0);
const average = nums => sum(nums) / nums.length;

const median = nums => {
  const sorted = nums.slice().sort((a, b) => a - b);
  const length = sorted.length;
  const middle = length / 2 - 1;
  return isEven(length)
    ? average([sorted[middle], sorted[middle + 1]])
    : sorted[Math.ceil(middle)];
}

const spreadsheetFunctions = {
  sum,
  average,
  median
}

const applyFunction = str => {
  const noHigh = highPrecedence(str);
  const infix = /([\d.]+)([+-])([\d.]+)/;
  const str2 = infixEval(noHigh, infix);
  const functionCall = /([a-z0-9]*)\(([0-9., ]*)\)(?!.*\()/i;
  const toNumberList = args => args.split(",").map(parseFloat);
  const apply = (fn, args) => spreadsheetFunctions[fn.toLowerCase()](toNumberList(args));
  return str2.replace(functionCall, (match, fn, args) => spreadsheetFunctions.hasOwnProperty(fn.toLowerCase()) ? apply(fn, args) : match);
}

const range = (start, end) => Array(end - start + 1).fill(start).map((element, index) => element + index);
const charRange = (start, end) => range(start.charCodeAt(0), end.charCodeAt(0)).map(code => String.fromCharCode(code));

--fcc-editable-region--
const evalFormula = (x, cells) => {
  const idToText = id => cells.find(cell => cell.id === id).value;
  const rangeRegex = /([A-J])([1-9][0-9]?):([A-J])([1-9][0-9]?)/gi;
  const rangeFromString = (num1, num2) => range(parseInt(num1), parseInt(num2));
  const elemValue = num => character => idToText(character + num);
  const addCharacters = character1 => character2 => num => charRange(character1, character2).map(elemValue(num));
  const rangeExpanded = x.replace(rangeRegex, (_match, char1, num1, char2, num2) => rangeFromString(num1, num2).map(addCharacters(char1)(char2)));
  const cellRegex = /[A-J][1-9][0-9]?/gi;
  const cellExpanded = rangeExpanded.replace(cellRegex, match => idToText(match.toUpperCase()));
  const functionExpanded = applyFunction(cellExpanded);

}
--fcc-editable-region--

window.onload = () => {
  const container = document.getElementById("container");
  const createLabel = (name) => {
    const label = document.createElement("div");
    label.className = "label";
    label.textContent = name;
    container.appendChild(label);
  }
  const letters = charRange("A", "J");
  letters.forEach(createLabel);
  range(1, 99).forEach(number => {
    createLabel(number);
    letters.forEach(letter => {
      const input = document.createElement("input");
      input.type = "text";
      input.id = letter + number;
      input.ariaLabel = letter + number;
      input.onchange = update;
      container.appendChild(input);
    })
  })
}

const update = event => {
  const element = event.target;
  const value = element.value.replace(/\s/g, "");
  if (!value.includes(element.id) && value.startsWith('=')) {

  }
}
```
