---
id: 5dc2385ff86c76b9248c6eb7
title: Step 5
challengeType: 0
dashedName: step-5
---

# --description--

HTML5 has some elements that identify different content areas. These elements make your HTML easier to read and help with Search Engine Optimization (SEO) and accessibility.

The `main` element is used to represent the main content of the body of an HTML document. Content inside the `main` element should be unique to the document and should not be repeated in other parts of the document.

```html
<main>
  <h1>Most important content of the document</h1>
  <p>Some more important content...</p>
</main>
```

Identify the main section of this page by adding a `<main>` opening tag before the `h1` element, and a `</main>` closing tag after the `p` element.

# --hints--

Your `main` element should have an opening tag. Opening tags have this syntax: `<elementName>`.

```js
assert(document.querySelector('main'));
```

Your `main` tags should be in lowercase. By convention, all HTML tags are written in lowercase.

```js
const mainTagMatches = code.matchAll(/<\/?main>/gi);
for (const match of mainTagMatches) {
  const tag = match[0];
  assert.strictEqual(
    tag,
    tag.toLowerCase()
  );
}
```

Your `main` element should have a closing tag. Closing tags have a `/` just after the `<` character.

```js
assert(code.match(/<\/main\>/));
```

Your `main` element's opening tag should be below the `body` element's opening tag. You have them in the wrong order.

```js
const main = document.querySelector('main');
assert.equal(main?.previousElementSibling, null);
```

Your `main` element's opening tag should be above the `h1` element. You have them in the wrong order.

```js
const collection = [...document.querySelectorAll('main,h1')].map(
  (node) => node.nodeName
);
assert(collection.indexOf('MAIN') < collection.indexOf('H1'));
```

Your `main` element's closing tag should be below the `p` element. You have them in the wrong order.

```js
const mainNode = document.querySelector('main');
const pNode = document.querySelector('p');
assert.isTrue(mainNode.contains(pNode));
assert.match(pNode.textContent.toLowerCase(), /everyone loves cute cats online!/);
```

# --seed--

## --seed-contents--

```html
<html>
  <body>
--fcc-editable-region--
  
    <h1>CatPhotoApp</h1>
    <h2>Cat Photos</h2>
    <!-- TODO: Add link to cat photos -->
    <p>Everyone loves cute cats online!</p>
    
--fcc-editable-region--
  </body>
</html>
```

