---
id: 5ef9b03c81a63668521804db
title: Step 43
challengeType: 0
dashedName: step-43
---

# --description--

To prevent a user from submitting your form when required information is missing, you need to add the `required` attribute to an `input` element.

Here is an example of an input field with the `required` attribute:

```html
<input type="text" name="firstName" required>
```

There's no need to set a value to the `required` attribute. Instead, just add the word `required` to the `input` element, making sure there is space between it and other attributes.

# --hints--

You have either deleted your `input` element or it has invalid syntax. All attributes' values should be surrounded by quotation marks.

```js
assert(document.querySelectorAll('input').length);
```

Your `form` should only contain the `input` element. Remove any additional HTML elements or text within the `form` element.

```js
assert.isTrue(
  document.querySelector('form')?.children?.length === 1 &&
    document.querySelector('form')?.innerText?.trim()?.length === 0
);
```

Your `input` element should have a `required` attribute. Remember, you just add the word `required` inside the `input` element's tag.

```js
assert.isTrue(document.querySelector('input')?.hasAttribute('required'));
```

A value should not be given to the `required` attribute.

```js
assert.strictEqual(document.querySelector('input')?.getAttribute('required'), '');
```

# --seed--

## --seed-contents--

```html
<html>
  <body>
    <main>
      <h1>CatPhotoApp</h1>
      <section>
        <h2>Cat Photos</h2>
        <p>Everyone loves <a href="https://cdn.freecodecamp.org/curriculum/cat-photo-app/running-cats.jpg">cute cats</a> online!</p>
        <p>See more <a target="_blank" href="https://freecatphotoapp.com">cat photos</a> in our gallery.</p>
        <a href="https://freecatphotoapp.com"><img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="A cute orange cat lying on its back."></a>
      </section>
      <section>
        <h2>Cat Lists</h2>
        <h3>Things cats love:</h3>
        <ul>
          <li>catnip</li>
          <li>laser pointers</li>
          <li>lasagna</li>
        </ul>
        <figure>
          <img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/lasagna.jpg" alt="A slice of lasagna on a plate.">
          <figcaption>Cats <em>love</em> lasagna.</figcaption>  
        </figure>
        <h3>Top 3 things cats hate:</h3>
        <ol>
          <li>flea treatment</li>
          <li>thunder</li>
          <li>other cats</li>
        </ol>
        <figure>
          <img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/cats.jpg" alt="Two tabby kittens sleeping together on a couch.">
          <figcaption>Cats <strong>hate</strong> other cats.</figcaption>  
        </figure>
      </section>
      <section>
        <h2>Cat Form</h2>
        <form action="https://freecatphotoapp.com/submit-cat-photo">
--fcc-editable-region--
          <input type="text" name="catphotourl" placeholder="cat photo URL">
--fcc-editable-region--
        </form>
      </section>
    </main>
  </body>
</html>
```

