---
id: 5ef9b03c81a63668521804e5
title: Step 63
challengeType: 0
dashedName: step-63
---

# --description--

In order to make a checkbox checked or radio button selected by default, you need to add the `checked` attribute to it. 

Here is an example of a radio button with the `checked` attribute:

```html
<input checked type="radio" name="meal" value="breakfast"> Breakfast
```

There's no need to set a value to the `checked` attribute. Instead, just add the word `checked` to the `input` element, making sure there is space between it and other attributes.

Make the first radio button and the first checkbox selected by default.

# --hints--

Make sure there still are two radio buttons and three checkboxes nested in their respective `fieldset` elements.

```js
assert.isTrue(
  document.querySelectorAll('input[type="radio"]').length === 2 &&
     document.querySelectorAll('fieldset > input[type="checkbox"]').length === 3
);
```

Your first radio button, with the `id` set to `indoor`, should have the `checked` attribute.

```js
assert.isTrue(document.querySelector('input[type="radio"]')?.hasAttribute('checked'));
```

The second radio button should not have the `checked` attribute.

```js
assert.isFalse(document.querySelectorAll('input[type="radio"]')?.[1]?.hasAttribute('checked'));
```

The first checkbox is missing the `checked` attribute.

```js
assert.isTrue(document.querySelector('input[type="checkbox"]')?.hasAttribute('checked'));
```

The second checkbox should not have the `checked` attribute.

```js
assert.isFalse(document.querySelectorAll('input[type="checkbox"]')?.[1]?.hasAttribute('checked'));
```

The third checkbox should not have the `checked` attribute.

```js
assert.isFalse(document.querySelectorAll('input[type="checkbox"]')?.[2]?.hasAttribute('checked'));
```

# --seed--

## --seed-contents--

```html
<html>
  <body>
    <main>
      <h1>CatPhotoApp</h1>
      <section>
        <h2>Cat Photos</h2>
        <p>Everyone loves <a href="https://cdn.freecodecamp.org/curriculum/cat-photo-app/running-cats.jpg">cute cats</a> online!</p>
        <p>See more <a target="_blank" href="https://freecatphotoapp.com">cat photos</a> in our gallery.</p>
        <a href="https://freecatphotoapp.com"><img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="A cute orange cat lying on its back."></a>
      </section>
      <section>
        <h2>Cat Lists</h2>
        <h3>Things cats love:</h3>
        <ul>
          <li>catnip</li>
          <li>laser pointers</li>
          <li>lasagna</li>
        </ul>
        <figure>
          <img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/lasagna.jpg" alt="A slice of lasagna on a plate.">
          <figcaption>Cats <em>love</em> lasagna.</figcaption>  
        </figure>
        <h3>Top 3 things cats hate:</h3>
        <ol>
          <li>flea treatment</li>
          <li>thunder</li>
          <li>other cats</li>
        </ol>
        <figure>
          <img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/cats.jpg" alt="Two tabby kittens sleeping together on a couch.">
          <figcaption>Cats <strong>hate</strong> other cats.</figcaption>  
        </figure>
      </section>
      <section>
        <h2>Cat Form</h2>
        <form action="https://freecatphotoapp.com/submit-cat-photo">
--fcc-editable-region--
          <fieldset>
            <legend>Is your cat an indoor or outdoor cat?</legend>
            <label><input id="indoor" type="radio" name="indoor-outdoor" value="indoor"> Indoor</label>
            <label><input id="outdoor" type="radio" name="indoor-outdoor" value="outdoor"> Outdoor</label>
          </fieldset>
          <fieldset>
            <legend>What's your cat's personality?</legend>
            <input id="loving" type="checkbox" name="personality" value="loving"> <label for="loving">Loving</label>
            <input id="lazy" type="checkbox" name="personality" value="lazy"> <label for="lazy">Lazy</label>
            <input id="energetic" type="checkbox" name="personality" value="energetic"> <label for="energetic"> Energetic</label>
          </fieldset>
--fcc-editable-region--
          <input type="text" name="catphotourl" placeholder="cat photo URL" required>
          <button type="submit">Submit</button>
        </form>
      </section>
    </main>
  </body>
</html>
```

