---
id: 60fab4a123ce4b04526b082b
title: Step 28
challengeType: 0
dashedName: step-28
---

# --description--

Currently users can submit the form without checking the radio inputs. Although you previously used the `required` attribute to indicate that an input is required, it won't work in this case because adding `required` to both inputs will convey the wrong information to users.

To solve this, you can provide context of what is needed by adding a `legend` element with text `Account type (required)` before the `label` elements within the second `fieldset`. Then add the `checked` attribute to the `Personal` input to ensure the form is submitted with the required data in it.

# --hints--

Your `input` elements should remain `type` of `radio`.

```js
assert.equal(document.querySelectorAll('fieldset:nth-child(2) input[type="radio"]')?.length, 2);
```

You should add a `legend` element within the second `fieldset` element.

```js
assert.equal(document.querySelectorAll('fieldset:nth-of-type(2) > legend')?.length, 1);
```

You should add `Account type (required)` text to the `legend` element.

```js
assert.equal(document.querySelector('fieldset:nth-of-type(2) > legend')?.textContent, 'Account type (required)');
```

You should give an attribute of `checked` to the `Personal` input.

```js
assert.isTrue(document.querySelector('fieldset:nth-child(2) input[type="radio"]')?.hasAttribute('checked'));
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8">
    <title>Registration Form</title>
    <link rel="stylesheet" href="styles.css" />
  </head>
  <body>
    <h1>Registration Form</h1>
    <p>Please fill out this form with the required information</p>
    <form method="post" action='https://register-demo.freecodecamp.org'>
      <fieldset>
        <label for="first-name">Enter Your First Name: <input id="first-name" type="text" required /></label>
        <label for="last-name">Enter Your Last Name: <input id="last-name" type="text" required /></label>
        <label for="email">Enter Your Email: <input id="email" type="email" required /></label>
        <label for="new-password">Create a New Password: <input id="new-password" type="password" pattern="[a-z0-5]{8,}" required /></label>
      </fieldset>
--fcc-editable-region--
      <fieldset>

        <label><input type="radio" name="account-type" /> Personal</label>
        <label><input type="radio" name="account-type" /> Business</label>
      </fieldset>
--fcc-editable-region--
      <fieldset></fieldset>
      <input type="submit" value="Submit" />
    </form>
  </body>
</html>
```

```css
body {
  width: 100%;
  height: 100vh;
  margin: 0;
  background-color: #1b1b32;
  color: #f5f6f7;
}

label {
  display: block;
  margin: 0.5rem 0;
}

```
