---
id: 662f96576ef178927de87975
title: Step 7
challengeType: 20
dashedName: step-7
---

# --description--

In order to be recognized as an abstract method, a method should be decorated with the `@abstractmethod` decorator.

A <dfn>decorator</dfn> is used in Python to modify the behavior of a function. Here's an example of how to use a decorator named `spam`:

```py
@spam
def foo():
    pass
```

Modify your import statement to import the `abstractmethod` decorator and decorate both the `solve` and `analyze` methods of the `Equation` class. This will raise two exceptions.

Once a class inheriting from `ABC` has an abstract method, the class cannot be instantiated anymore. Therefore, delete the `Equation` instance to get rid of the error.

The other error occurs because the `LinearEquation` class must implement all the abstract methods defined in the interface. Make sure to define them inside the `LinearEquation` class, too. You must not use the `abstractmethod` decorator in the concrete class.

# --hints--

You should import `abstractmethod` from the `abc` module.

```js
({ test: () => assert(runPython(`
_Node(_code).has_import("from abc import ABC, abstractmethod") or \\
_Node(_code).has_import("from abc import abstractmethod, ABC") or \\
(_Node(_code).has_import("from abc import abstractmethod") and _Node(_code).has_import("from abc import ABC"))
`)) })
```

You should decorate with `@abstractmethod` the `solve` method within the `Equation` class.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("solve").has_decorators("abstractmethod")`)) })
```

You should decorate with `@abstractmethod` the `analyze` method within the `Equation` class.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("analyze").has_decorators("abstractmethod")`)) })
```

You should define a method named `solve` within the `LinearEquation` class.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("LinearEquation").has_function("solve")`)) })
```

Your `solve` method should take one parameter, `self`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("LinearEquation").find_function("solve").has_args("self")`)) })
```

You should define a method named `analyze` within the `LinearEquation` class.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("LinearEquation").has_function("analyze")`)) })
```

Your `solve` method should take one parameter, `self`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("LinearEquation").find_function("analyze").has_args("self")`)) })
```

# --seed--

## --seed-contents--

```py
--fcc-editable-region--
from abc import ABC


class Equation(ABC):
    def solve(self):
        pass
        
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    pass

eq = Equation()
lin_eq = LinearEquation()
--fcc-editable-region--
```
