---
id: 662fa2e2cf27c09f21f4f5d0
title: Step 9
challengeType: 20
dashedName: step-9
---

# --description--

In Python, data types are recognized during runtime (when the code is executed). Therefore, you don't have to specify the data type of a variable when you declare it. Nonetheless, you can annotate a variable to clarify that it will hold a specific data type with `variable: <data type> = value` or just `variable: <data type>`. Note that the Python interpreter does not enforce the types used to annotate variables, and normally you'd need external tools to do it.

Inside the `Equation` class, define a class attribute `degree`. Do not assign it a value. Instead use a type annotation of `int` to show that it will store an integer number inside the concrete classes.

Later on, you'll use this class attribute as a part of the validation process of the arguments passed to instantiate the equation objects.

# --hints--

You should define class attribute named `degree` and annotate it with `int` within the `Equation` class.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_variable("degree").is_equivalent("degree: int")`)) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod
--fcc-editable-region--
class Equation(ABC):
    def __init__(self):
        pass
    
    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass


class LinearEquation(Equation):
    def solve(self):
        pass

    def analyze(self):
        pass
--fcc-editable-region--
lin_eq = LinearEquation()
```
