---
id: 663a32735b317af9812eb0d7
title: Step 27
challengeType: 20
dashedName: step-27
---

# --description--

In linear equations in the form \\( ax + b = 0 \\), the slope is simply the coefficient \\( a \\), and the y-intercept is the coefficient \\( b \\).

<img alt="a plot of a linear function" src="https://cdn.freecodecamp.org/curriculum/python/linear-equation.png" style="background-color: white; height: 350px; width: auto; padding: 15px; display: block; margin-right: auto; margin-left: auto; margin-bottom: 1.2rem;">

You are going to use the `analyze` method to provide additional information about the equation. Inside the `analyze` method, unpack the coefficients into the variables `slope` and `intercept`.

Then, return a dictionary with the keys `'slope'` and `'intercept'` and the values of the slope and the y-intercept, respectively. After that, call `analyze` on `lin_eq` and print the result.


# --hints--

You should unpack the values stored in the `coefficients` attribute into the variables `slope` and `intercept` inside the `analyze` method.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("LinearEquation").find_function("analyze").has_stmt("slope, intercept = self.coefficients.values()")`)) })
```

The `analyze` method should return a dictionary with the keys `'slope'` and `'intercept'` and the values of the slope and the y-intercept, respectively.

```js
({ test: () => runPython(`
eq = LinearEquation(2.2, 1.5)
a = eq.analyze()
assert a['slope'] == 2.2, "Expected different slope"
assert a['intercept'] == 1.5, "Expected different intercept"
`) })
```

You should call the `analyze` method of your `lin_eq` object.

```js
({ test: () => assert(runPython(`_Node(_code).has_call("print(lin_eq.analyze())")`)) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Equation(ABC):
    degree: int
  
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}

    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )

    def __str__(self):
        terms = []
        for n, coefficient in self.coefficients.items():
            if not coefficient:
                continue
            if n == 0:
                terms.append(f'{coefficient:+}')
            elif n == 1:
                terms.append(f'{coefficient:+}x')                
        equation_string = ' '.join(terms) + ' = 0'
        return equation_string.strip('+')        
    
    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        a, b = self.coefficients.values()
        x = -b / a
        return x
--fcc-editable-region--
    def analyze(self):
        pass

lin_eq = LinearEquation(2, 3)
print(lin_eq)
print(lin_eq.solve())
--fcc-editable-region--
```
