---
id: 663b93aee129b3c4cc07d0db
title: Step 20
challengeType: 20
dashedName: step-20
---

# --description--

Just after the `terms` list, create a `for` loop and use the `.items()` method to iterate over the keys and values stored in the `coefficients` attribute. Use `n` and `coefficient` as the loop variables. 

Inside the loop, create an `if` statement that checks if the coefficient at the current iteration has a falsy value and skip the iteration in that case. This is because you don't want to represent coefficients with the value of zero.

# --hints--

You should create a `for` loop that iterates over `coefficients.items()`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("__str__").find_for_loops()[0].find_for_iter().is_equivalent("self.coefficients.items()")`)) })
```

Your `for` loop should use `n` and `coefficient` to iterate over `coefficients.items()`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("__str__").find_for_loops()[0].find_for_vars().is_equivalent("n, coefficient")`)) })
```

You should create an `if` statement to check if `coefficient` has a falsy value inside your `for` loop.

```js
({ test: () => assert(runPython(`
if_cond = _Node(_code).find_class("Equation").find_function("__str__").find_for_loops()[0].find_ifs()[0].find_conditions()[0]
conditions = ["not coefficient", "coefficient == 0", "0 == coefficient"]
any(if_cond.is_equivalent(condition) for condition in conditions)
`)) })
```

You should use the `continue` keyword inside your new `if` statement.

```js
({ test: () => assert(runPython(`
_Node(_code).find_class("Equation").find_function("__str__").find_for_loops()[0].find_ifs()[0].find_bodies()[0].has_stmt("continue")
`)) })
```

Your `for` loop should be placed just after the declaration of `terms`.

```js
({ test: () => assert(runPython(`
loop = str(_Node(_code).find_class("Equation").find_function("__str__").find_for_loops()[0])
_Node(_code).find_class("Equation").find_function("__str__").is_ordered("terms = []", loop, "equation_string = ' '.join(terms)", "return equation_string")
`)) })
```


# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Equation(ABC):
    degree: int
    
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}

    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )
--fcc-editable-region--
    def __str__(self):
        terms = []
        
--fcc-editable-region--
        equation_string = ' '.join(terms)
        return equation_string        
    
    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        pass
    
    def analyze(self):
        pass


lin_eq = LinearEquation(2, 3)
print(lin_eq)
```
