---
id: 663b95d65caeb3ca04c5fef4
title: Step 21
challengeType: 20
dashedName: step-21
---

# --description--

If the coefficient has a non-zero value, you can have different cases. If `n == 0`, the term is made by the coefficient itself.

After your `if` statement, create another `if` statement for this case and append a string containing the coefficient to the `terms` list. Use an f-string for that.

# --hints--

You should create an `if` statement to check if `n` is equal to `0` after your existing `if` statement.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("__str__").find_for_loops()[0].find_ifs()[1].find_conditions()[0].is_equivalent("n==0")`)) })
```

You should append `f'{coefficient}'` to the `terms` list within your new `if` statement.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("__str__").find_for_loops()[0].find_ifs()[1].find_bodies()[0].is_equivalent("terms.append(f'{coefficient}')")`)) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Equation(ABC):
    degree: int
    
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}

    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )
--fcc-editable-region--
    def __str__(self):
        terms = []
        for n, coefficient in self.coefficients.items():
            if not coefficient:
                continue
        equation_string = ' '.join(terms)
        return equation_string
--fcc-editable-region--    
    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        pass
    
    def analyze(self):
        pass
    
lin_eq = LinearEquation(2, 3)
print(lin_eq)
```
