---
id: 663c981b9b06922e13a97fe9
title: Step 22
challengeType: 20
dashedName: step-22
---

# --description--

Create an `elif` clause for the case `n == 1`. Within the `elif` clause, create an f-string containing the coefficient directly followed by a lowercase `x` and append it to the `terms` list.

# --hints--

You should create an `elif` clause to check if `n` is equal to `1`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("__str__").find_for_loops()[0].find_ifs()[1].find_conditions()[1].is_equivalent("n==1")`)) })
```

You should append `f'{coefficient}x'` to the `terms` list within your new `elif` clause.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("__str__").find_for_loops()[0].find_ifs()[1].find_bodies()[1].is_equivalent("terms.append(f'{coefficient}x')")`)) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Equation(ABC):
    degree: int
  
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}

    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )
--fcc-editable-region--
    def __str__(self):
        terms = []
        for n, coefficient in self.coefficients.items():
            if not coefficient:
                continue
            if n == 0:
                terms.append(f'{coefficient}')
        equation_string = ' '.join(terms)
        return equation_string
--fcc-editable-region--
        
    
    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        pass
    
    def analyze(self):
        pass
    
lin_eq = LinearEquation(2, 3)
print(lin_eq)
```
