---
id: 663c9f31306353460da54542
title: Step 23
challengeType: 20
dashedName: step-23
---

# --description--

As you can see, the `+` sign is missing from the output. The number sign is displayed by default only if negative. To change this behavior, you can write a colon after the expression to be evaluated within the curly braces of your f-string, and specify the option `+`. This will allow you to display the sign both for positive and negative numbers.

Modify the string in your two conditional clauses by adding `:+` inside the curly braces after `coefficient`.

# --hints--

You should modify the string to append to the `terms` list within your `if` statement into `f'{coefficient:+}'`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("__str__").find_for_loops()[0].find_ifs()[1].find_bodies()[0].is_equivalent("terms.append(f'{coefficient:+}')")`)) })
```

You should modify the string to insert into the `terms` list within your `elif` clause into `f'{coefficient:+}x'`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("__str__").find_for_loops()[0].find_ifs()[1].find_bodies()[1].is_equivalent("terms.append(f'{coefficient:+}x')")`)) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Equation(ABC):
    degree: int
  
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}

    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )
--fcc-editable-region--
    def __str__(self):
        terms = []
        for n, coefficient in self.coefficients.items():
            if not coefficient:
                continue
            if n == 0:
                terms.append(f'{coefficient}')
            elif n == 1:
                terms.append(f'{coefficient}x')                
        equation_string = ' '.join(terms)        
        return equation_string
--fcc-editable-region--    
    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        pass
    
    def analyze(self):
        pass
    
lin_eq = LinearEquation(2, 3)
print(lin_eq)
```
