---
id: 664e4e1b6c35a99cbba49e84
title: Step 31
challengeType: 20
dashedName: step-31
---

# --description--

Now, create an instance of the `QuadraticEquation` class to represent the equation \\( 11x^2 - x + 1 = 0 \\).

Assign the new instance to a variable `quadr_eq`, then print your new variable. Note that, at this point, the second degree term would be missing from the string representation of the equation.

# --hints--

You should declare a variable named `quadr_eq` and assign it an instance of `QuadraticEquation` passing it `11`, `-1`, and `1` as the arguments.

```js
({ test: () => assert(runPython(`_Node(_code).has_stmt("quadr_eq = QuadraticEquation(11, -1, 1)")`)) })
```

You should print your `quadr_eq` variable.

```js
({ test: () => assert(runPython(`_Node(_code).has_call("print(quadr_eq)")`)) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod

class Equation(ABC):
    degree: int
  
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}

    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )

    def __str__(self):
        terms = []
        for n, coefficient in self.coefficients.items():
            if not coefficient:
                continue
            if n == 0:
                terms.append(f'{coefficient:+}')
            elif n == 1:
                terms.append(f'{coefficient:+}x')                
        equation_string = ' '.join(terms) + ' = 0'
        return equation_string.strip('+')        
    
    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        a, b = self.coefficients.values()
        x = -b / a
        return x

    def analyze(self):
        slope, intercept = self.coefficients.values()
        return {'slope': slope, 'intercept': intercept}

class QuadraticEquation(Equation):
    degree = 2

    def __init__(self, *args):
        super().__init__(*args)
        a, b, c = self.coefficients.values()
        self.delta = b**2 - 4 * a * c
   
    def solve(self):
        pass
    
    def analyze(self):
        pass
--fcc-editable-region-- 
lin_eq = LinearEquation(2, 3)
print(lin_eq)

--fcc-editable-region--
```
