---
id: 664eec7f38234443b42c206f
title: Step 33
challengeType: 20
dashedName: step-33
---

# --description--

Your equation is currently represented as `11x**2 -1x +1 = 0`, but it would be nice not to display the coefficient multiplying \\( x \\) when it's equal to one. So that equation is represented as `11x**2 -x +1 = 0`.

Import the `re` module. You are going to use a regular expression to substitute the coefficients for this case during the next steps.

# --hints--

You should import the `re` module.

```js
({ test: () => assert(runPython(`_Node(_code).has_import("import re")`)) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod
--fcc-editable-region--

--fcc-editable-region--
class Equation(ABC):
    degree: int
  
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}

    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )

    def __str__(self):
        terms = []
        for n, coefficient in self.coefficients.items():
            if not coefficient:
                continue
            if n == 0:
                terms.append(f'{coefficient:+}')
            elif n == 1:
                terms.append(f'{coefficient:+}x')
            else:
                terms.append(f"{coefficient:+}x**{n}")
        equation_string = ' '.join(terms) + ' = 0'
        return equation_string.strip('+')        
    
    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        a, b = self.coefficients.values()
        x = -b / a
        return x

    def analyze(self):
        slope, intercept = self.coefficients.values()
        return {'slope': slope, 'intercept': intercept}

class QuadraticEquation(Equation):
    degree = 2

    def __init__(self, *args):
        super().__init__(*args)
        a, b, c = self.coefficients.values()
        self.delta = b**2 - 4 * a * c
   
    def solve(self):
        pass
    
    def analyze(self):
        pass


lin_eq = LinearEquation(2, 3)
print(lin_eq)
quadr_eq = QuadraticEquation(11, -1, 1)
print(quadr_eq)

```
