---
id: 664eef158d792a509e8d708a
title: Step 34
challengeType: 20
dashedName: step-34
---

# --description--

The `sub` function from the `re` module enables you to replace text inside a string based on a regex pattern.

```py
verse = 'Always look on the bright side of life'
spam = re.sub('bright', 'spam', verse)
spam == 'Always look on the spam side of life' # True
```

It takes three arguments: the regex pattern to match, the replacement, and the string on which you want to perform the replacement.

From your `__str__` method, return a `sub()` call passing the string `'1'`, an empty string, and your existing `equation_string.strip('+')` call as the arguments. This will replace each `1` with an empty string. The result is not refined yet and you'll continue to work on the regex pattern in the next steps.

# --hints--

You should return a `re.sub()` call from your `__str__` method. Pass the string `'1'`, an empty string, and your existing `equation_string.strip('+')` call as the arguments to `re.sub()`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("__str__").has_return("re.sub('1', '', equation_string.strip('+'))")`)) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod
import re


class Equation(ABC):
    degree: int
  
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}

    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )

    def __str__(self):
        terms = []
        for n, coefficient in self.coefficients.items():
            if not coefficient:
                continue
            if n == 0:
                terms.append(f'{coefficient:+}')
            elif n == 1:
                terms.append(f'{coefficient:+}x')
            else:
                terms.append(f"{coefficient:+}x**{n}")
        equation_string = ' '.join(terms) + ' = 0'
--fcc-editable-region--
        return equation_string.strip('+')        
--fcc-editable-region--
    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        a, b = self.coefficients.values()
        x = -b / a
        return x

    def analyze(self):
        slope, intercept = self.coefficients.values()
        return {'slope': slope, 'intercept': intercept}

class QuadraticEquation(Equation):
    degree = 2

    def __init__(self, *args):
        super().__init__(*args)
        a, b, c = self.coefficients.values()
        self.delta = b**2 - 4 * a * c
   
    def solve(self):
        pass
    
    def analyze(self):
        pass


lin_eq = LinearEquation(2, 3)
print(lin_eq)
quadr_eq = QuadraticEquation(11, -1, 1)
print(quadr_eq)

```
