---
id: 664ef4623946e65e18d59764
title: Step 35
challengeType: 20
dashedName: step-35
---

# --description--

In a regex pattern, a *lookaround* is an assertion that matches a certain pattern without consuming characters in the string. One kind of lookaround is the lookbehind, which can be either positive or negative. They are denoted by `(?<=...)` and `(?<!...)`, respectively.

```py
spam = 'black back bat'
re.sub('(?<=l)a', 'o', spam) == 'block back bat' # True
re.sub('(?<!l)a', 'o', spam) == 'black bock bot' # True
```

In the example above, the pattern `(?<=l)a` contains a positive lookbehind, which is used to match the `a` character only when preceded by an `l`. In the last line of the example, the pattern `(?<!l)a` contains a negative lookbehind, which is used to match the `a` character only if it is **not** preceded by an `l`. Note how, in both cases, the character contained in the lookbehind is not consumed.

Modify your regex pattern to use a negative lookbehind so that the character `1` is substituted only if not preceded by a digit.

# --hints--

You should modify the pattern passed as the first argument to the `re.sub()` call using a negative lookbehind.

```js
({ test: () => assert(runPython(`
node = _Node(_code).find_class("Equation").find_function("__str__")
values = [
  "re.sub('(?<!\\d)1', '', equation_string.strip('+'))",
  "re.sub(r'(?<!\\d)1', '', equation_string.strip('+'))",
  "re.sub('(?<![0-9])1', '', equation_string.strip('+'))"
]
any(node.has_return(value) for value in values)
`)) })
```



# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod
import re


class Equation(ABC):
    degree: int
  
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}

    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )

    def __str__(self):
        terms = []
        for n, coefficient in self.coefficients.items():
            if not coefficient:
                continue
            if n == 0:
                terms.append(f'{coefficient:+}')
            elif n == 1:
                terms.append(f'{coefficient:+}x')
            else:
                terms.append(f"{coefficient:+}x**{n}")
        equation_string = ' '.join(terms) + ' = 0'
--fcc-editable-region--
        return re.sub('1', '', equation_string.strip('+'))        
--fcc-editable-region--
    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        a, b = self.coefficients.values()
        x = -b / a
        return x

    def analyze(self):
        slope, intercept = self.coefficients.values()
        return {'slope': slope, 'intercept': intercept}

class QuadraticEquation(Equation):
    degree = 2

    def __init__(self, *args):
        super().__init__(*args)
        a, b, c = self.coefficients.values()
        self.delta = b**2 - 4 * a * c
   
    def solve(self):
        pass
    
    def analyze(self):
        pass


lin_eq = LinearEquation(2, 3)
print(lin_eq)
quadr_eq = QuadraticEquation(11, -1, 1)
print(quadr_eq)

```
