---
id: 664f0389424a6f7aa15fd3e5
title: Step 36
challengeType: 20
dashedName: step-36
---

# --description--

Another kind of lookaround assertion is the lookahead. Positive and negative lookahead are denoted by `(?=...)` and `(?!...)`, respectively. They are used to match a pattern if followed by a certain sequence of characters, which is not consumed:

```py
spam = 'black back bat'
re.sub('a(?=t)', 'o', spam) == 'black back bot' # True
re.sub('a(?!t)', 'o', spam) == 'block bock bat' # True
```

In the example above, the pattern `a(?=t)` contains a positive lookahead, which is used to match the `a` character only when followed by a `t`. In the last line of the example, the pattern `a(?!t)` contains a negative lookahead, which is used to match the `a` character only if **not** followed by a `t`. Again, in both cases, the character contained in the lookahead is not consumed.

Add a positive lookahead to your regex pattern so that the character `1` is substituted only if followed by the character `x`.

# --hints--

You should modify your regex pattern using a positive lookahead to substitute the character `1` only if followed by an `x`. Do not remove the negative lookbehind from your pattern.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("__str__").has_return("re.sub(r'(?<!\\d)1(?=x)', '', equation_string.strip('+'))")`)) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod
import re


class Equation(ABC):
    degree: int
  
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}

    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )

    def __str__(self):
        terms = []
        for n, coefficient in self.coefficients.items():
            if not coefficient:
                continue
            if n == 0:
                terms.append(f'{coefficient:+}')
            elif n == 1:
                terms.append(f'{coefficient:+}x')
            else:
                terms.append(f"{coefficient:+}x**{n}")
        equation_string = ' '.join(terms) + ' = 0'
--fcc-editable-region--
        return re.sub(r'(?<!\d)1', '', equation_string.strip('+'))        
--fcc-editable-region--
    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        a, b = self.coefficients.values()
        x = -b / a
        return x

    def analyze(self):
        slope, intercept = self.coefficients.values()
        return {'slope': slope, 'intercept': intercept}

class QuadraticEquation(Equation):
    degree = 2

    def __init__(self, *args):
        super().__init__(*args)
        a, b, c = self.coefficients.values()
        self.delta = b**2 - 4 * a * c
   
    def solve(self):
        pass
    
    def analyze(self):
        pass


lin_eq = LinearEquation(2, 3)
print(lin_eq)
quadr_eq = QuadraticEquation(11, -1, 1)
print(quadr_eq)

```
