---
id: 6650f037c017aa6855a608e3
title: Step 44
challengeType: 20
dashedName: step-44
---

# --description--

The graph of any quadratic equation has a parabolic shape. The \\( x \\) coordinate of the vertex of the parabola can be found at \\( x = - \frac{b}{2a} \\).

From the `analyze` method, return the dictionary containing two keys, `'x'`, and `'y'`, and the corresponding values of the vertex \\( x \\) and \\( y \\) coordinates, respectively.

Use the relation above to find the \\( x \\) coordinate. Then, use the \\( x \\) coordinate to calculate the \\( y \\) coordinate.

# --hints--

You should return a dictionary containing two keys, `'x'`, and `'y'`, and the corresponding values of vertex `x` and `y` coordinates, respectively.

```js
({ test: () => runPython(`
eq = QuadraticEquation(16, 2, 1)
assert eq.analyze() == {'x': -0.0625, 'y': 0.9375}
`) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod
import re


class Equation(ABC):
    degree: int
  
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}

    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )

    def __str__(self):
        terms = []
        for n, coefficient in self.coefficients.items():
            if not coefficient:
                continue
            if n == 0:
                terms.append(f'{coefficient:+}')
            elif n == 1:
                terms.append(f'{coefficient:+}x')
            else:
                terms.append(f"{coefficient:+}x**{n}")
        equation_string = ' '.join(terms) + ' = 0'
        return re.sub(r"(?<!\d)1(?=x)", "", equation_string.strip("+"))        

    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        a, b = self.coefficients.values()
        x = -b / a
        return [x]

    def analyze(self):
        slope, intercept = self.coefficients.values()
        return {'slope': slope, 'intercept': intercept}

class QuadraticEquation(Equation):
    degree = 2

    def __init__(self, *args):
        super().__init__(*args)
        a, b, c = self.coefficients.values()
        self.delta = b**2 - 4 * a * c

    def solve(self):
        if self.delta < 0:
            return []
        a, b, _ = self.coefficients.values()
        x1 = (-b + (self.delta) ** 0.5) / (2 * a)
        x2 = (-b - (self.delta) ** 0.5) / (2 * a)
        if self.delta == 0:
            return [x1]

        return [x1, x2]
--fcc-editable-region--
    def analyze(self):
        pass
--fcc-editable-region--
lin_eq = LinearEquation(2, 3)
print(lin_eq)
quadr_eq = QuadraticEquation(1, 2, 1)
print(quadr_eq)
print(quadr_eq.solve())

```
