---
id: 667938f754145d165c25725d
title: Step 50
challengeType: 20
dashedName: step-50
---

# --description--

An interesting feature of f-strings is the capability of forcing the output to be right/left-aligned, or centered. After the expression to be evaluated is inside the curly braces, you need to write a colon followed by an alignment option (`<` to left-align, `>` to right-align, `^` to center) and a number representing the width, that is the number of characters in which you want to arrange the text. For example:

```py
f'{"Hello World":>20}'
```

Printing the string from the example above would result in right-aligned text arranged in a space of 20 characters.

Back to the `solver` function, after your `if` statement, create a variable named `output_string` and assign it an f-string containing the equation type centered in a width of `24` characters. Make the string begin with a new line character, and return `output_string` from your function.

Then, call the `solver` function passing `lin_eq` as the argument, and print the result.

# --hints--

You should define a variable named `output_string` and assign it `f'\n{equation.type:^24}'`.

```js
({ test: () => assert(runPython(`_Node(_code).find_function("solver").has_stmt("output_string = f'\\\\n{equation.type:^24}'")`)) })
```

Your `solver` function should return `output_string`.

```js
({ test: () => assert(runPython(`_Node(_code).find_function("solver").has_return("output_string")`)) })
```

You should print `solver(lin_eq)`.

```js
({ test: () => assert(runPython(`_Node(_code).has_call("print(solver(lin_eq))")`)) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod
import re


class Equation(ABC):
    degree: int
    type: str
  
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}

    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )
        if not hasattr(cls, "type"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'type'"
            )
            
    def __str__(self):
        terms = []
        for n, coefficient in self.coefficients.items():
            if not coefficient:
                continue
            if n == 0:
                terms.append(f'{coefficient:+}')
            elif n == 1:
                terms.append(f'{coefficient:+}x')
            else:
                terms.append(f"{coefficient:+}x**{n}")
        equation_string = ' '.join(terms) + ' = 0'
        return re.sub(r"(?<!\d)1(?=x)", "", equation_string.strip("+"))        

    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass


class LinearEquation(Equation):
    degree = 1
    type = 'Linear Equation'
    
    def solve(self):
        a, b = self.coefficients.values()
        x = -b / a
        return [x]

    def analyze(self):
        slope, intercept = self.coefficients.values()
        return {'slope': slope, 'intercept': intercept}


class QuadraticEquation(Equation):
    degree = 2
    type = 'Quadratic Equation'

    def __init__(self, *args):
        super().__init__(*args)
        a, b, c = self.coefficients.values()
        self.delta = b**2 - 4 * a * c

    def solve(self):
        if self.delta < 0:
            return []
        a, b, _ = self.coefficients.values()
        x1 = (-b + (self.delta) ** 0.5) / (2 * a)
        x2 = (-b - (self.delta) ** 0.5) / (2 * a)
        if self.delta == 0:
            return [x1]

        return [x1, x2]

    def analyze(self):
        a, b, c = self.coefficients.values()
        x = -b / (2 * a)
        y = a * x**2 + b * x + c
        if a > 0:
            concavity = 'upwards'
            min_max = 'min'
        else:
            concavity = 'downwards'
            min_max = 'max'
        return {'x': x, 'y': y, 'min_max': min_max, 'concavity': concavity}
--fcc-editable-region--
def solver(equation):
    if not isinstance(equation, Equation):
        raise TypeError("Argument must be an Equation object")


lin_eq = LinearEquation(2, 3)
quadr_eq = QuadraticEquation(1, 2, 1)
--fcc-editable-region--
```
