---
id: 66793c5b4bdacc17c40ff8e7
title: Step 52
challengeType: 20
dashedName: step-52
---

# --description--

Another feature of f-strings enables you to convert the content of the replacement field (the curly braces) into a string by using a `!` followed by the conversion type `s`. For example, `f'{obj!s}'` converts `obj` into a string and it is equivalent to `f'{str(obj)}'`.

From now on, you'll keep building the output by concatenating strings to `output_string`.

Create a string containing the string representation of your equation centered in a width of `24` characters. Make the string begin and end with two newline characters, and add your new string to the current value of `output_string`.

The output of the `solver` function should look like this:

```md

----Linear Equation-----

       2x +3 = 0        

```

# --hints--

The `solver` function should return a different string.

```js
({ test: () => runPython(`
eq = LinearEquation(4, 3)
expected = """
----Linear Equation-----

       4x +3 = 0        

"""
assert solver(eq) == expected
`) })
```

You should use the conversion flag `!s` to convert `equation` into a string.

```js
({ test: () => (runPython(`
function = str(_Node(_code).find_function("solver"))
assert "equation!s" in function
`)) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod
import re


class Equation(ABC):
    degree: int
    type: str
  
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'Equation' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
        if any(not isinstance(arg, (int, float)) for arg in args):
            raise TypeError("Coefficients must be of type 'int' or 'float'")
        if args[0] == 0:
            raise ValueError("Highest degree coefficient must be different from zero")
        self.coefficients = {(len(args) - n - 1): arg for n, arg in enumerate(args)}

    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )
        if not hasattr(cls, "type"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'type'"
            )
            
    def __str__(self):
        terms = []
        for n, coefficient in self.coefficients.items():
            if not coefficient:
                continue
            if n == 0:
                terms.append(f'{coefficient:+}')
            elif n == 1:
                terms.append(f'{coefficient:+}x')
            else:
                terms.append(f"{coefficient:+}x**{n}")
        equation_string = ' '.join(terms) + ' = 0'
        return re.sub(r"(?<!\d)1(?=x)", "", equation_string.strip("+"))        

    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass


class LinearEquation(Equation):
    degree = 1
    type = 'Linear Equation'
    
    def solve(self):
        a, b = self.coefficients.values()
        x = -b / a
        return [x]

    def analyze(self):
        slope, intercept = self.coefficients.values()
        return {'slope': slope, 'intercept': intercept}


class QuadraticEquation(Equation):
    degree = 2
    type = 'Quadratic Equation'

    def __init__(self, *args):
        super().__init__(*args)
        a, b, c = self.coefficients.values()
        self.delta = b**2 - 4 * a * c

    def solve(self):
        if self.delta < 0:
            return []
        a, b, _ = self.coefficients.values()
        x1 = (-b + (self.delta) ** 0.5) / (2 * a)
        x2 = (-b - (self.delta) ** 0.5) / (2 * a)
        if self.delta == 0:
            return [x1]

        return [x1, x2]

    def analyze(self):
        a, b, c = self.coefficients.values()
        x = -b / (2 * a)
        y = a * x**2 + b * x + c
        if a > 0:
            concavity = 'upwards'
            min_max = 'min'
        else:
            concavity = 'downwards'
            min_max = 'max'
        return {'x': x, 'y': y, 'min_max': min_max, 'concavity': concavity}


def solver(equation):
    if not isinstance(equation, Equation):
        raise TypeError("Argument must be an Equation object")
--fcc-editable-region--
    output_string = f'\n{equation.type:-^24}'
    
--fcc-editable-region--
    return output_string

lin_eq = LinearEquation(2, 3)
quadr_eq = QuadraticEquation(1, 2, 1)
print(solver(lin_eq))

```
