---
id: 667e623208053643ca9d3c6e
title: Step 15
challengeType: 20
dashedName: step-15
---

# --description--

Now, replace the `for` loop and `if` statement you added in the previous step with an `if` statement that uses the `any()` built-in function.

# --hints--

The condition of your new `if` statement should be a call to `any()`.

```js
({ test: () => runPython(`
cond = _Node(_code).find_class("Equation").find_function("__init__").find_ifs()[1].find_conditions()[0]
calls = _Node(str(cond)).find_calls("any")
assert len(calls) == 1
`) })
```

You should pass a generator expression as the argument to your `any()` call.

```js
({ test: () => runPython(`
import ast
argument = _Node(_code).find_class("Equation").find_function("__init__").find_ifs()[1].find_conditions()[0].find_call_args()[0]
assert isinstance(argument.tree, ast.GeneratorExp)
`) })
```

The generator expression passed to `any()` should iterate over `args`.

```js
({ test: () => runPython(`
import ast
argument = _Node(_code).find_class("Equation").find_function("__init__").find_ifs()[1].find_conditions()[0].find_call_args()[0]
iters = argument.find_comp_iters()
assert len(iters) == 1
assert iters[0].is_equivalent("args")
`) })
```

Your `if` statement should check if any of the arguments in `args` is not an instance of either `int` or `float`.

```js
({ test: () => runPython(`
import ast
argument = _Node(_code).find_class("Equation").find_function("__init__").find_ifs()[1].find_conditions()[0].find_call_args()[0]
target = argument.find_comp_targets()[0]
expr = argument.find_comp_expr()
solutions = [
  f"not isinstance({target}, (int, float))",
  f"not isinstance({target}, (float, int))",
  f"not isinstance({target}, float) and not isinstance({target}, int)",
  f"not isinstance({target}, int) and not isinstance({target}, float)",
]
assert any(expr.is_equivalent(sol) for sol in solutions)
`) })
```

You should use the provided string to raise a `TypeError` within your new `if` statement.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Equation").find_function("__init__").find_ifs()[1].find_bodies()[0].has_stmt("raise TypeError(\\"Coefficients must be of type 'int' or 'float'\\")")
`)) })
```

# --seed--

## --seed-contents--

```py
from abc import ABC, abstractmethod


class Equation(ABC):
    degree: int
    
    def __init__(self, *args):
        if (self.degree + 1) != len(args):
            raise TypeError(
                f"'{self.__class__.__name__}' object takes {self.degree + 1} positional arguments but {len(args)} were given"
            )
--fcc-editable-region--
        for arg in args:
            if not isinstance(arg, (int, float)):
                raise TypeError("Coefficients must be of type 'int' or 'float'")
--fcc-editable-region--
    def __init_subclass__(cls):
        if not hasattr(cls, "degree"):
            raise AttributeError(
                f"Cannot create '{cls.__name__}' class: missing required attribute 'degree'"
            )
    
    @abstractmethod
    def solve(self):
        pass
        
    @abstractmethod
    def analyze(self):
        pass
        
class LinearEquation(Equation):
    degree = 1
    
    def solve(self):
        pass
    
    def analyze(self):
        pass
    
lin_eq = LinearEquation(2, 3)
```
