---
id: 657f456223b8c1187b461987
title: Step 19
challengeType: 20
dashedName: step-19
---

# --description--

In Python, a <dfn>list comprehension</dfn> is a construct that allows you to generate a new list by applying an expression to each item in an existing iterable and optionally filtering items with a condition. Apart from being briefer, list comprehensions often run faster.

A basic list comprehension consists of an expression followed by a `for` clause:

```py
spam = [i * 2 for i in iterable]
```

The above uses the variable `i` to iterate over `iterable`. Each elements of the resulting list is obtained by evaluating the expression `i * 2` at the current iteration.

In this step, you need to fill the empty list `snake_cased_char_list` using the list comprehension syntax.

Turn your empty list into a list comprehension that converts each character in `pascal_or_camel_cased_string` into a lowercase character and prepends an underscore to it (the code you commented out before may help you write the expression). Use `char` to iterate over `pascal_or_camel_cased_string`. 

# --hints--

You should turn `snake_cased_char_list` into a list comprehension that iterates over `pascal_or_camel_cased_string`.

```js
({ 
    test: () => assert(runPython(`
    iters = _Node(_code).find_function("convert_to_snake_case").find_variable("snake_cased_char_list").find_comp_iters()
    len(iters) == 1 and iters[0].is_equivalent("pascal_or_camel_cased_string")
    `)) 
})
```

Your list comprehension should use `char` to iterate over `pascal_or_camel_cased_string`.

```js
({ 
    test: () => assert(runPython(`
    targets = _Node(_code).find_function("convert_to_snake_case").find_variable("snake_cased_char_list").find_comp_targets()
    len(targets) == 1 and targets[0].is_equivalent("char")
    `)) 
})
```

Your list comprehension should evaluate `'_' + char.lower()` for each `char` in `pascal_or_camel_cased_string`.

```js
({ 
    test: () => assert(runPython(`
    target_var = _Node(_code).find_function("convert_to_snake_case").find_variable("snake_cased_char_list")
    target_var.find_comp_expr().is_equivalent("'_' + char.lower()") and len(target_var.find_comp_ifs()) == 0
    `)) 
})
```

# --seed--

## --seed-contents--

```py
def convert_to_snake_case(pascal_or_camel_cased_string):
    # snake_cased_char_list = []
    # for char in pascal_or_camel_cased_string:
    #     if char.isupper():
    #       converted_character = '_' + char.lower()
    #       snake_cased_char_list.append(converted_character)
    #     else:
    #         snake_cased_char_list.append(char)
    # snake_cased_string = ''.join(snake_cased_char_list)
    # clean_snake_cased_string = snake_cased_string.strip('_')

    # return clean_snake_cased_string

--fcc-editable-region--
    snake_cased_char_list = []
--fcc-editable-region--
    return ''.join(snake_cased_char_list).strip('_')

def main():
    print(convert_to_snake_case('aLongAndComplexString'))

main()
```
