---
id: 657f465f8e718b19c5105ae5
title: Step 20
challengeType: 20
dashedName: step-20
---

# --description--

List comprehensions accept conditional statements, to evaluate the provided expression only if certain conditions are met:

```py
spam = [i * 2 for i in iterable if i > 0]
```

As you can see from the output, the list of characters generated from `pascal_or_camel_cased_string` has been joined. Since the expression inside the list comprehension is evaluated for each character, the result is a lowercase string with all the characters separated by an underscore.

Follow the example above to add an `if` clause to your list comprehension so that the expression is executed only if the character is uppercase.

# --hints--

You should add an `if` clause with the condition `char.isupper()` to your list comprehension.

```js
({ 
    test: () => assert(runPython(`
    ifs = _Node(_code).find_function("convert_to_snake_case").find_variable("snake_cased_char_list").find_comp_ifs()
    len(ifs) == 1 and ifs[0].is_equivalent("char.isupper()")
    `))
})
```

# --seed--

## --seed-contents--

```py
def convert_to_snake_case(pascal_or_camel_cased_string):
    # snake_cased_char_list = []
    # for char in pascal_or_camel_cased_string:
    #     if char.isupper():
    #       converted_character = '_' + char.lower()
    #       snake_cased_char_list.append(converted_character)
    #     else:
    #         snake_cased_char_list.append(char)
    # snake_cased_string = ''.join(snake_cased_char_list)
    # clean_snake_cased_string = snake_cased_string.strip('_')

    # return clean_snake_cased_string

--fcc-editable-region--
    snake_cased_char_list = ['_' + char.lower() for char in pascal_or_camel_cased_string]
--fcc-editable-region--
    return ''.join(snake_cased_char_list).strip('_')

def main():
    print(convert_to_snake_case('aLongAndComplexString'))

main()
```
