---
id: 61fd5a93fd62bb35968adeab
title: Step 1
challengeType: 0
dashedName: step-1
demoType: onLoad
---

# --description--

Set up your HTML with the `DOCTYPE`, `html` indicating this document is in English, `head`, and `body` elements.

Give your `head` element the appropriate `meta` elements for the `charset` and `viewport`, a `title` element with an appropriate title, and a `link` element for your stylesheet.

# --hints--

Your code should have a `<!DOCTYPE html>` declaration.

```js
assert(code.match(/<!DOCTYPE html>/i));
```

Your code should have an `html` element.

```js
assert.equal(document.querySelectorAll('html')?.length, 1);
```

Your `html` element should have an opening tag with a `lang` attribute of `en`.

```js
assert(code.match(/<html\s+lang\s*=\s*('|")en\1\s*>/gi));
```

Your `html` element should have a closing tag.

```js
assert(code.match(/<\/html\s*>/));
```

Your code should have a `head` element within the `html` element.

```js
assert.equal(document.querySelectorAll('head')?.length, 1);
```

Your code should have a `body` element within the `html` element.

```js
assert.equal(document.querySelectorAll('body')?.length, 1);
```

Your `head` element should come before your `body` element.

```js
assert.equal(document.querySelector('body')?.previousElementSibling?.tagName, 'HEAD');
```

You should have two `meta` elements.

```js
const meta = document.querySelectorAll('meta');
assert.equal(meta?.length, 2);
```

One `meta` element should have a `name` set to `viewport`, and `content` set to `width=device-width, initial-scale=1.0`.

```js
const meta = [...document.querySelectorAll('meta')];
const target = meta?.find(m => m?.getAttribute('name') === 'viewport' && m?.getAttribute('content') === 'width=device-width, initial-scale=1.0' && !m?.getAttribute('charset'));
assert.exists(target);
```

The other `meta` element should have the `charset` attribute set to `UTF-8`.

```js
const meta = [...document.querySelectorAll('meta')];
const target = meta?.find(m => !m?.getAttribute('name') && !m?.getAttribute('content') && m?.getAttribute('charset')?.toLowerCase() === 'utf-8');
assert.exists(target);
```

Your code should have a `title` element.

```js
const title = document.querySelector('title');
assert.exists(title);
```

Your `title` should have some text.

```js
const title = document.querySelector('title');
assert.isAtLeast(title?.textContent?.length, 1);
```

Your code should have a `link` element.

```js
assert(/<link/.test(code))
```

Your `link` element should be within your `head` element.

```js
assert(code.match(/<head>[\w\W\s]*<link[\w\W\s]*\/?>[\w\W\s]*<\/head>/i))
```

Your `link` element should have a `rel` attribute with the value `stylesheet`.

```js
assert.match(code, /<link[\s\S]*?rel=('|"|`)stylesheet\1/)
```

Your `link` element should have an `href` attribute with the value `styles.css`.

```js
assert.match(code, /<link[\s\S]*?href=('|"|`)(\.\/)?styles\.css\1/)
```

# --seed--

## --seed-contents--

```html
--fcc-editable-region--

--fcc-editable-region--
```

```css

```
