---
id: 656475bbf1c2573de1d2c69c
title: Step 11
challengeType: 20
dashedName: step-11
---

# --description--

Every time the code runs, you should see a random character from the `all_characters` string. This is exactly what you want to achieve to create a random password.

However, the algorithm on which `random` relies makes the generated pseudo-random numbers predictable. Therefore, although the `random` module is suitable for the most common applications, it cannot be used for cryptographic purposes, due to its deterministic nature. 

Instead of importing `random`, import the `secrets` module. Then change the `print()` call to use `secrets.choice(all_characters)`.

# --hints--

You should import the `secrets` module instead of the `random` module.

```js
({
  test: () => {
    assert.match(code, /^import\s+secrets/m)
    assert.isFalse( /^import\s+random/m.test(code))
  }
})
```

You should modify your existing `print()` call to print `secrets.choice(all_characters)`.

```js
({ test: () => assert.match(code, /^print\s*\(\s*secrets\.choice\s*\(\s*all_characters\s*\)\s*\)/m) })
```

# --seed--

## --seed-contents--

```py
--fcc-editable-region--
import random
import string


# Define the possible characters for the password
letters = string.ascii_letters
digits = string.digits
symbols = string.punctuation

# Combine all characters
all_characters = letters + digits + symbols

print(all_characters)
print(random.choice(all_characters))
--fcc-editable-region--
```
