---
id: 6564d97a5ef99783216a6229
title: Step 44
challengeType: 20
dashedName: step-44
---

# --description--

Python provides a particular type of string called *raw* string. Raw strings are prefixed with a `r`. The key distinction from regular strings lies in how they handle the backslash character: in raw strings, backslashes are treated as literal characters rather than escape characters. When writing regular expressions, using raw strings is a good practice, since they can usually contain a lot of `\` characters.

Turn your `pattern` string into a raw string by prefixing it with a `r`.

# --hints--

You should modify your `pattern` variable into `r'\.'`.

```js
({ test: () => assert.match(code, /^pattern\s*=\s*r("|')\\\.\1/m) })
```

# --seed--

## --seed-contents--

```py
import re
import secrets
import string


def generate_password(length, nums, special_chars, uppercase, lowercase):
    # Define the possible characters for the password
    letters = string.ascii_letters
    digits = string.digits
    symbols = string.punctuation

    # Combine all characters
    all_characters = letters + digits + symbols

    while True:
        password = ''
        # Generate password
        for _ in range(length):
            password += secrets.choice(all_characters)
        
        constraints = [
            (nums, '[0-9]'),
            (lowercase, '[a-z]'),
            (uppercase, '[A-Z]'),
            (special_chars, '')
        ]        

    return password
    
# new_password = generate_password(8)
# print(new_password)
--fcc-editable-region--
pattern = '\.'
quote = 'Not all those who wander are lost.'
print(re.findall(pattern, quote))
--fcc-editable-region--
```
