---
id: 642208bc4d44701c6fd6f65e
title: Step 16
challengeType: 0
dashedName: step-16
---

# --description--

The dollar value may be more than one digit. To match this, the `+` quantifier can be used - this matches one or more consecutive occurrences. For example, the regular expression `/a+/` matches one or more consecutive `a` characters.

Update your regular expression to match one or more consecutive digits.

# --hints--

Your `dollarRegex` should use the `+` quantifier.

```js
assert.match(dollarRegex.source, /\+/);
```

Your `dollarRegex` should use the `+` quantifier on your `[0-9]` character class.

```js
assert.match(dollarRegex.source, /\[0-9\]\+/);
```

Your `dollarRegex` should still match `"100 dollars"`.

```js
assert.match('100 dollars', dollarRegex);
```

Your `dollarRegex` should still match `"3 dollars"`.

```js
assert.match('3 dollars', dollarRegex);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width" />
    <title>Learn Regular Expressions by Building a Spam Filter</title>
    <link rel="stylesheet" href="styles.css" />
  </head>

  <body>
    <header class="main-text">
      <h1 class="title">Is this Spam?</h1>
      <p class="description">
        Enter a phrase to check if it would be marked as spam or not.
      </p>
    </header>

    <main>
      <label class="message-label" for="message-input">Message: </label>
      <textarea
        placeholder="Enter message here"
        value=""
        type="text"
        name="message"
        id="message-input"
        rows="10"
        cols="40"
      ></textarea>
      <button class="btn" id="check-message-btn" type="button">
        Check message
      </button>
      <p id="result"></p>
    </main>

    <footer class="footer">&copy; freeCodeCamp</footer>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
*,
*::before,
*::after {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
}

:root {
  --dark-grey: #1b1b32;
  --light-grey: #f5f6f7;
  --golden-yellow: #fecc4c;
  --yellow: #ffcc4c;
  --gold: #feac32;
  --orange: #ffac33;
  --dark-orange: #f89808;
}

body {
  background-color: var(--dark-grey);
  color: var(--light-grey);
}

body,
#message-input:placeholder-shown {
  text-align: center;
}

textarea {
  max-width: 90%;
}

.main-text {
  margin: 25px 0;
}

.title {
  font-size: 2.5rem;
}

.description {
  margin-top: 15px;
  font-size: 1.4rem;
}

.message-label {
  display: block;
  margin-bottom: 20px;
  font-size: 1.5rem;
}

#message-input:placeholder-shown,
textarea {
  font-size: 1.1rem;
}

.btn {
  display: block;
  cursor: pointer;
  width: 200px;
  margin: 10px auto;
  color: var(--dark-grey);
  background-color: var(--gold);
  background-image: linear-gradient(var(--golden-yellow), var(--orange));
  border-color: var(--gold);
  border-width: 3px;
}

.btn:hover {
  background-image: linear-gradient(var(--yellow), var(--dark-orange));
}

#result {
  font-size: 2rem;
  margin: 20px 0;
}

.footer {
  margin-top: 10px;
}
```

```js
const messageInput = document.getElementById("message-input");
const result = document.getElementById("result");
const checkMessageButton = document.getElementById("check-message-btn");

const helpRegex = /please help|assist me/i;
--fcc-editable-region--
const dollarRegex = /[0-9] dollars/i;
--fcc-editable-region--

const denyList = [helpRegex, dollarRegex];

const isSpam = (msg) => denyList.some((regex) => regex.test(msg));

checkMessageButton.addEventListener("click", () => {
  if (messageInput.value === "") {
    alert("Please enter a message.");
    return;
  }

  result.textContent = isSpam(messageInput.value)
    ? "Oh no! This looks like a spam message."
    : "This message does not seem to contain any spam.";
  messageInput.value = "";
});
```
