---
id: 65f412c208c3791fee305acf
title: Step 17
challengeType: 20
dashedName: step-17
---

# --description--

In Python, you can enforce the use of keyword-only arguments by adding a `*` as an additional argument to the function or method signature. Modify both `__init__` methods by adding a `*` as the second parameter (after `self`). Every parameter placed after that will require the use of a keyword argument in the function/method call.

This means that you need to modify the `super().__init__(x, y)` call, too. Do it by giving `x` the value `x`, and `y` the value `y`.

Finally, modify the instantiation of `v1` and `v2` by using keyword arguments.

# --hints--

You should enforce keyword arguments by adding a `*` as the second parameter in both your `__init__` methods.

```js
({ test: () => {
  assert(runPython(`_Node(_code).find_class("R2Vector").find_function("__init__").has_args("self, *, x, y")`));
  assert(runPython(`_Node(_code).find_class("R3Vector").find_function("__init__").has_args("self, *, x, y, z")`));
} })
```

You should modify your `super.__init__(x, y)` call to  use keyword arguments.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R3Vector").find_function("__init__").find_body().is_equivalent("super().__init__(x=x, y=y)\\nself.z = z")`)) })
```

You should modify the assignment of `v1` to be `R2Vector(x=2, y=3)`.

```js
({ test: () => assert(runPython(`_Node(_code).find_variable("v1").is_equivalent("v1 = R2Vector(x=2, y=3)")`)) })
```

You should modify the assignment of `v2` to be `R3Vector(x=2, y=2, z=3)`.

```js
({ test: () => assert(runPython(`_Node(_code).find_variable("v2").is_equivalent("v2 = R3Vector(x=2, y=2, z=3)")`)) })
```

# --seed--

## --seed-contents--

```py
--fcc-editable-region--
class R2Vector:
    def __init__(self, x, y):
        self.x = x
        self.y = y
        
    def norm(self):
        return (self.x**2 + self.y**2)**0.5
        
    def __str__(self):
        return f'{self.x, self.y}'

class R3Vector(R2Vector):
    def __init__(self, x, y, z):
        super().__init__(x, y)
        self.z = z

v1 = R2Vector(2, 3)
print(v1.norm())
print(v1)
v2 = R3Vector(2, 2, 3)
--fcc-editable-region--
```
