---
id: 65f4520e363e2642f8112e33
title: Step 19
challengeType: 20
dashedName: step-19
---

# --description--

As you can see, something is not quite right. The `norm` and `__str__` methods inherited from `R2Vector` cannot adapt to a 3-dimensional vector. Their implementation has to be more flexible.

Every object in Python has a special attribute named `__dict__`, which is a dictionary that stores the object attributes.

Remove the existing `print` calls. Then, print the `__dict__` attribute of your `v1` and `v2` vectors to see what they look like.

# --hints--

You should not have `print(v2)` and `print(v2.norm())` in your code.

```js
({
    test: () => {
      assert.isFalse(runPython(`_Node(_code).has_call("print(v2)")`));
      assert.isFalse(runPython(`_Node(_code).has_call("print(v2.norm())")`));
    }
})
```

You should print the `__dict__` attribute of `v1` and `v2`.

```js
({ test: () => assert(runPython(`
(_Node(_code).has_call("print(v1.__dict__)") and _Node(_code).has_call("print(v2.__dict__)")) or _Node(_code).has_call("print(v1.__dict__, v2.__dict__)")
`)) })
```

# --seed--

## --seed-contents--

```py

class R2Vector:
    def __init__(self, *, x, y):
        self.x = x
        self.y = y
        
    def norm(self):
        return (self.x**2 + self.y**2)**0.5
        
    def __str__(self):
        return f'{self.x, self.y}'

class R3Vector(R2Vector):
    def __init__(self, *, x, y, z):
        super().__init__(x=x, y=y)
        self.z = z
--fcc-editable-region--
v1 = R2Vector(x=2, y=3)
v2 = R3Vector(x=2, y=2, z=3)
print(v2.norm())
print(v2)
--fcc-editable-region--
```
