---
id: 65f9b9710cca621244d3bde1
title: Step 40
challengeType: 20
dashedName: step-40
---

# --description--

In Python, `NotImplemented` is a special value used to indicate that an operation is not implemented for a specific case.

`NotImplemented` does not raise an exception immediately. Instead, it signals to ask to the other operand how to perform the operation. If the request cannot be satisfied, a `TypeError` is returned by default.

Because you want to be able to sum two vectors only if they belong to the same class, return `NotImplemented` from the `if` statement you created in the previous step.

# --hints--

You should return `NotImplemented` from within the `if` body.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R2Vector").find_function("__add__").find_ifs()[0].find_bodies()[0].has_return("NotImplemented")`)) })
```

# --seed--

## --seed-contents--

```py
class R2Vector:
    def __init__(self, *, x, y):
        self.x = x
        self.y = y

    def norm(self):
        return sum(val**2 for val in vars(self).values())**0.5

    def __str__(self):
        return str(tuple(getattr(self, i) for i in vars(self)))

    def __repr__(self):
        arg_list = [f'{key}={val}' for key, val in vars(self).items()]
        args = ', '.join(arg_list)
        return f'{self.__class__.__name__}({args})'
--fcc-editable-region--
    def __add__(self, other):
        if type(self) != type(other):
            pass
--fcc-editable-region--
class R3Vector(R2Vector):
    def __init__(self, *, x, y, z):
        super().__init__(x=x, y=y)
        self.z = z

v1 = R2Vector(x=2, y=3)
v2 = R3Vector(x=2, y=2, z=3)
print(f'v1 = {v1}')
print(f'v2 = {v2}')
```
