---
id: 65f9dd6e5a08af19c196c2df
title: Step 45
challengeType: 20
dashedName: step-45
---

# --description--

The vector resulting from the subtraction of one vector from another is obtained by calculating the difference of each of their components. For example, subtracting `(2, 4)` from `(7, 3)` generates a third vector `(5, -1)`, where `5` is the difference between `7` and `2` and `-1` is the difference between `3` and `4`.

As you did before inside the `__add__` method, declare a `kwargs` variable after the `if` statement. Assign it a dictionary comprehension that iterates through the object attributes and creates a key-value pair for each key `i`, where the key is the same key as the current iteration and its value is the difference between the values of the `i` attributes of two operands.

# --hints--

You should declare a variable `kwargs` and assign it a dictionary comprehension that iterates over the object attributes.

```js
({ test: () => assert(runPython(`
node = _Node(_code).find_class("R2Vector").find_function("__sub__").find_variable("kwargs").find_comp_iters()[0]
node.is_equivalent("vars(self)") or node.is_equivalent("self.__dict__")`)) })
```

The dictionary comprehension assigned to `kwargs` should use the variable `i` to iterate over the object attributes.

```js
({
    test: () => assert(runPython(`
      _Node(_code).find_class("R2Vector").find_function("__sub__").find_variable("kwargs").find_comp_targets()[0].is_equivalent("i")
    `))
})
```

The dictionary comprehension assigned to `kwargs` should use `i` as the key.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R2Vector").find_function("__sub__").find_variable("kwargs").find_comp_key().is_equivalent("i")`)) })
```

The dictionary comprehension assigned to `kwargs` should assign the difference between the `i` attribute of `self` and the `i` attribute of `other` to the `i` key for each `i`.

```js
({ test: () => assert(runPython(`
node = _Node(_code).find_class("R2Vector").find_function("__sub__").find_variable("kwargs").find_comp_expr()
node.is_equivalent("getattr(self, i) - getattr(other, i)") or node.is_equivalent("self.__getattribute__(i) - other.__getattribute__(i)")
`)) })
```

# --seed--

## --seed-contents--

```py
class R2Vector:
    def __init__(self, *, x, y):
        self.x = x
        self.y = y

    def norm(self):
        return sum(val**2 for val in vars(self).values())**0.5

    def __str__(self):
        return str(tuple(getattr(self, i) for i in vars(self)))

    def __repr__(self):
        arg_list = [f'{key}={val}' for key, val in vars(self).items()]
        args = ', '.join(arg_list)
        return f'{self.__class__.__name__}({args})'

    def __add__(self, other):
        if type(self) != type(other):
            return NotImplemented
        kwargs = {i: getattr(self, i) + getattr(other, i) for i in vars(self)}
        return self.__class__(**kwargs)
--fcc-editable-region--
    def __sub__(self, other):
        if type(self) != type(other):
            return NotImplemented
--fcc-editable-region--
class R3Vector(R2Vector):
    def __init__(self, *, x, y, z):
        super().__init__(x=x, y=y)
        self.z = z

v1 = R2Vector(x=2, y=3)
v2 = R3Vector(x=2, y=2, z=3)
print(f'v1 = {v1}')
print(f'v2 = {v2}')
```
