---
id: 65fc87e19930a503e5f05500
title: Step 53
challengeType: 20
dashedName: step-53
---

# --description--

A vector can be multiplied by another vector, too. This operation is called *dot product*, or *scalar product*.

Create an `elif` clause that checks if `other` is an object of the same class of the current instance.

You are going to implement the dot product inside this block during the next step.

# --hints--

You should create an `elif` clause that checks if `other` is an object of the same class of the current instance.

```js
({ test: () => assert(runPython(`
node = _Node(_code).find_class("R2Vector").find_function("__mul__").find_ifs()[0].find_conditions()[1]
node.is_equivalent("type(self) == type(other)") or node.is_equivalent("type(other) == type(self)")
`)) })
```

# --seed--

## --seed-contents--

```py
class R2Vector:
    def __init__(self, *, x, y):
        self.x = x
        self.y = y

    def norm(self):
        return sum(val**2 for val in vars(self).values())**0.5

    def __str__(self):
        return str(tuple(getattr(self, i) for i in vars(self)))

    def __repr__(self):
        arg_list = [f'{key}={val}' for key, val in vars(self).items()]
        args = ', '.join(arg_list)
        return f'{self.__class__.__name__}({args})'

    def __add__(self, other):
        if type(self) != type(other):
            return NotImplemented
        kwargs = {i: getattr(self, i) + getattr(other, i) for i in vars(self)}
        return self.__class__(**kwargs)

    def __sub__(self, other):
        if type(self) != type(other):
            return NotImplemented
        kwargs = {i: getattr(self, i) - getattr(other, i) for i in vars(self)}
        return self.__class__(**kwargs)
--fcc-editable-region--
    def __mul__(self, other):
        if type(other) in (int, float):
            kwargs = {i: getattr(self, i) * other for i in vars(self)}
            return self.__class__(**kwargs)
--fcc-editable-region--
class R3Vector(R2Vector):
    def __init__(self, *, x, y, z):
        super().__init__(x=x, y=y)
        self.z = z

v1 = R2Vector(x=2, y=3)
v2 = R2Vector(x=0.5, y=1.25)
print(f'v1 = {v1}')
print(f'v2 = {v2}')
v3 = v1 + v2
print(f'v1 + v2 = {v3}')
v4 = v1 - v2
print(f'v1 - v2 = {v4}')

```
