---
id: 666827a6fd0dbaafe8330ea6
title: Step 35
challengeType: 20
dashedName: step-35
---

# --description--

`__getattr__` is another special method that plays a role in accessing attributes.

The default implementation of `__getattribute__` is to raise an `AttributeError` when the requested attribute is not an instance attribute or it is not present in the class tree.

In that case, `__getattr__` is called if defined by the class. You can consider it as a sort of fallback when the usual attribute accessing procedure fails.

Turn the `__getattribute__` method into `__getattr__` and modify the string returned by the method into `'calling __getattr__'`.

# --hints--

You should define a method named `__getattr__` with two parameters, `self` and `attr`, inside the `R2Vector` class.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R2Vector").find_function("__getattr__").has_args("self, attr")`)) })
```

Your `__getattr__` method should return the string `'calling __getattr__'`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R2Vector").find_function("__getattr__").has_return("'calling __getattr__'")`)) })
```

# --seed--

## --seed-contents--

```py
class R2Vector:
    def __init__(self, *, x, y):
        self.x = x
        self.y = y

    def norm(self):
        return sum(val**2 for val in vars(self).values())**0.5

    def __str__(self):
        return str(tuple(getattr(self, i) for i in vars(self)))

    def __repr__(self):
        arg_list = [f'{key}={val}' for key, val in vars(self).items()]
        args = ', '.join(arg_list)
        return f'{self.__class__.__name__}({args})'
--fcc-editable-region--
    def __getattribute__(self, attr):                
        return 'calling __getattribute__'
--fcc-editable-region--
class R3Vector(R2Vector):
    def __init__(self, *, x, y, z):
        super().__init__(x=x, y=y)
        self.z = z

v1 = R2Vector(x=2, y=3)
v2 = R3Vector(x=2, y=2, z=3)
# print(f'v1 = {v1}', f'\nrepr = {repr(v1)}')
# print(f'v2 = {v2}', f'\nrepr = {repr(v2)}')

print(v1.x)
print(getattr(v1, 'x'))

```
