---
id: 6551fe3b1df7c9740f13f270
title: Step 12
challengeType: 20
dashedName: step-12
---

# --description--

Key aspects of variable naming in Python are:

- Some words are reserved keywords (e.g. `for`, `while`, `True`). They have a special meaning in Python, so you cannot use them for variable names.
- Variable names cannot start with a number, and they can only contain alpha-numeric characters or underscores.
- Variable names are case sensitive, i.e. `my_var` is different from `my_Var` and `MY_VAR`.
- Finally, it is a common convention to write variable names using `snake_case`, where each space is replaced by an underscore character and the words are written in lowercase letters.

Remove both calls to `print()` and declare another variable called `alphabet`. Assign the string `'abcdefghijklmnopqrstuvwxyz'` to this variable.

# --hints--

You should not have `print(type(text))` in your code.

```js
const commentless_code = __helpers.python.removeComments(code);
assert.notMatch(commentless_code, /print\s*\(\s*type\s*\(\s*text\s*\)\s*\)/)
```

You should not have `print(type(shift))` in your code.

```js
const commentless_code = __helpers.python.removeComments(code);
assert.notMatch(commentless_code, /print\s*\(\s*type\s*\(\s*shift\s*\)\s*\)/)
```

You should declare a variable called `alphabet`. Pay attention to place the variable name at the beginning of the line.

```js
assert.match(code, /^alphabet\s*=/m)
```

You should assign the string `'abcdefghijklmnopqrstuvwxyz'` to your `alphabet` variable. Remember to use either single or double quotes to enclose the string.

```js
assert.match(code, /^alphabet\s*=\s*("|')abcdefghijklmnopqrstuvwxyz\1\s*(#.*)?$/m)
```

Your code contains invalid syntax and/or invalid indentation.

```js
({test: () => assert(true) })
```

# --seed--

## --seed-contents--

```py
--fcc-editable-region--
text = 'Hello World'
print(type(text))
shift = 3
print(type(shift))
--fcc-editable-region--
```
