---
id: 65ca03bd8eb5faf24b250c56
title: Step 33
challengeType: 20
dashedName: step-33
---

# --description--

The next step is to work on the deletion of nodes.
For that, you would follow the same approach by first defining a helper method and then the actual method.

Inside the `BinarySearchTree` class, define a new helper method called `_delete`  that takes three parameters: `self`, `node`, and `key`.

# --hints--

You should define the `_delete` method inside the `BinarySearchTree` class with the parameters `self`, `node` and `key`. Remember to use the `pass` keyword.

```js
({ test: () => assert.match(code, /def\s+_delete\(\s*self\s*,\s*node\s*,\s*key\s*\)/) })
```

# --seed--

## --seed-contents--

```py

class TreeNode:

    def __init__(self, key):
        self.key = key
        self.left = None
        self.right = None

    def __str__(self):
        return str(self.key)

class BinarySearchTree:

    def __init__(self):
        self.root = None

    def _insert(self, node, key):
        if node is None:
            return TreeNode(key)

        if key < node.key:
            node.left = self._insert(node.left, key)
        elif key > node.key:

            node.right = self._insert(node.right, key)
        return node

    def insert(self, key):
        self.root = self._insert(self.root, key)
        
    def _search(self, node, key):
        if node is None or node.key == key:
            return node
        if key < node.key:
            return self._search(node.left, key)
        return self._search(node.right, key)
    
    def search(self, key):
        return self._search(self.root, key)

--fcc-editable-region--


--fcc-editable-region--

bst = BinarySearchTree()

nodes = [50, 30, 20, 40, 70, 60, 80]

for node in nodes:
    bst.insert(node)

# print('Search for 80:', bst.search(80))

```
