---
id: 65ca06c9f918730107c9908d
title: Step 37
challengeType: 20
dashedName: step-37
---

# --description--

Write an `elif` statement that checks if `key > node.key`.

Inside your `elif` block, call the `_delete` method with the right child of the current node and `key` as the arguments and assign the result to the right node.

# --hints--

You should write an `elif` statement that checks if `key > node.key`.

```js
const after_split = code.split('def _delete(self, node, key):')[1];
assert.match(after_split, /elif\s+key\s+>\s+node\.key/);
```

You should call the `_delete` method with `node.right` and `key` as the arguments.

```js
assert.match(code, /self\._delete\(\s*node\.right\s*,\s*key\s*\)/);
```

You should assign the result of the `_delete()` call to `node.right`.

```js
assert.match(code, /node\.right\s*=\s*self\._delete\(\s*node\.right\s*,\s*key\s*\)/);
```

# --seed--

## --seed-contents--

```py

class TreeNode:

    def __init__(self, key):
        self.key = key
        self.left = None
        self.right = None

    def __str__(self):
        return str(self.key)

class BinarySearchTree:

    def __init__(self):
        self.root = None

    def _insert(self, node, key):
        if node is None:
            return TreeNode(key)

        if key < node.key:
            node.left = self._insert(node.left, key)
        elif key > node.key:

            node.right = self._insert(node.right, key)
        return node

    def insert(self, key):
        self.root = self._insert(self.root, key)
        
    def _search(self, node, key):
        if node is None or node.key == key:
            return node
        if key < node.key:
            return self._search(node.left, key)
        return self._search(node.right, key)
    
    def search(self, key):
        return self._search(self.root, key)

--fcc-editable-region--
    def _delete(self, node, key):
        if node is None:
            return node
        if key < node.key:
            node.left = self._delete(node.left, key)

--fcc-editable-region--

bst = BinarySearchTree()

nodes = [50, 30, 20, 40, 70, 60, 80]

for node in nodes:
    bst.insert(node)

# print('Search for 80:', bst.search(80))


```
