---
id: 65ca0794ec3ed103bca67ed7
title: Step 40
challengeType: 20
dashedName: step-40
---

# --description--

Below the `if` statement, add an `elif` clause to check if the right child of the current node (`node.right`) is `None`.

If the previous condition is met, it means there is no right child. So, return the left child of the current node from the `elif` block as a replacement.

# --hints--

You should create an `elif` statement that checks if the right child of the current node is `None`. 

```js
({test: () => assert(runPython(`_Node(_code).find_class("BinarySearchTree").find_function("_delete").find_ifs()[1].find_conditions()[3].is_equivalent("node.right is None")`))})
```

You should return the left child of the current node.

```js
({test: () => assert(runPython(`_Node(_code).find_class("BinarySearchTree").find_function("_delete").find_ifs()[1].find_bodies()[3].is_equivalent("return node.left")`))})
```

# --seed--

## --seed-contents--

```py

class TreeNode:

    def __init__(self, key):
        self.key = key
        self.left = None
        self.right = None

    def __str__(self):
        return str(self.key)

class BinarySearchTree:

    def __init__(self):
        self.root = None

    def _insert(self, node, key):
        if node is None:
            return TreeNode(key)

        if key < node.key:
            node.left = self._insert(node.left, key)
        elif key > node.key:

            node.right = self._insert(node.right, key)
        return node

    def insert(self, key):
        self.root = self._insert(self.root, key)
        
    def _search(self, node, key):
        if node is None or node.key == key:
            return node
        if key < node.key:
            return self._search(node.left, key)
        return self._search(node.right, key)
    
    def search(self, key):
        return self._search(self.root, key)

--fcc-editable-region--
    def _delete(self, node, key):
        if node is None:
            return node
        if key < node.key:
            node.left = self._delete(node.left, key)
        elif key > node.key:
            node.right = self._delete(node.right, key) 
        else:
            if node.left is None:
                return node.right

--fcc-editable-region--

bst = BinarySearchTree()

nodes = [50, 30, 20, 40, 70, 60, 80]

for node in nodes:
    bst.insert(node)
    
# print('Search for 80:', bst.search(80))

```
